/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2016 EXSolo <exsoloscripter at gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package com.exsoloscript.challonge.model;

import com.google.gson.annotations.SerializedName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.OffsetDateTime;

/**
 * The POJO that will be mapped to the participant requests by Gson
 *
 * @author EXSolo
 * @version 20160820.1
 */
@Data
@Accessors(fluent = true)
@EqualsAndHashCode(exclude = {"checkedInAt", "createdAt", "updatedAt"})
public class Participant {
    private final String name;
    @SerializedName("challonge_username")
    private final String challongeUsername;
    private final Integer seed;
    private final String misc;
    private final Boolean active;
    @SerializedName("checked_in_at")
    private final OffsetDateTime checkedInAt;
    @SerializedName("created_at")
    private final OffsetDateTime createdAt;
    @SerializedName("final_rank")
    private final Integer finalRank;
    @SerializedName("group_id")
    private final Integer groupId;
    private final String icon;
    private final Integer id;
    @SerializedName("invitation_id")
    private final Integer invitationId;
    @SerializedName("invite_email")
    private final String inviteEmail;
    @SerializedName("on_waiting_list")
    private final Boolean onWaitingList;
    @SerializedName("tournament_id")
    private final Integer tournamentId;
    @SerializedName("updated_at")
    private final OffsetDateTime updatedAt;
    @SerializedName("challonge_email_address_verified")
    private final String challongeEmailAddressVerified;
    private final Boolean removable;
    @SerializedName("participatable_or_invitation_attached")
    private final Boolean participatableOrInvitationAttached;
    @SerializedName("confirm_remove")
    private final Boolean confirmRemove;
    @SerializedName("invitation_pending")
    private final Boolean invitationPending;
    @SerializedName("display_name_with_invitation_email_address")
    private final String displayNameWithInvitationEmailAddress;
    @SerializedName("email_hash")
    private final String emailHash;
    private final String username;
    @SerializedName("attached_participatable_portrait_url")
    private final String attachedParticipatablePortraitUrl;
    @SerializedName("can_check_in")
    private final Boolean canCheckIn;
    @SerializedName("checked_in")
    private final Boolean checkedIn;
    private final Boolean reactivatable;
}
