/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.AsyncCallback;
import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.library.squareup.retrofit2.Call;
import com.exsoloscript.challonge.library.squareup.retrofit2.Callback;
import com.exsoloscript.challonge.library.squareup.retrofit2.Response;
import com.exsoloscript.challonge.model.exception.ChallongeException;
import com.exsoloscript.challonge.util.ErrorUtil;
import java.io.IOException;

public class RetrofitChallongeApiCall<T>
implements ChallongeApiCall<T> {
    private Call<T> retrofitCall;
    private ErrorUtil errorUtil;

    public RetrofitChallongeApiCall(Call<T> retrofitCall, ErrorUtil errorUtil) {
        this.retrofitCall = retrofitCall;
        this.errorUtil = errorUtil;
    }

    @Override
    public T sync() throws IOException, ChallongeException {
        Response<T> response = this.retrofitCall.execute();
        if (response.isSuccessful()) {
            return response.body();
        }
        this.errorUtil.parseException(response);
        return response.body();
    }

    @Override
    public void async(final AsyncCallback<T> callback) {
        this.retrofitCall.enqueue(new Callback<T>(){

            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful()) {
                    callback.handleSuccess(response.body());
                } else {
                    try {
                        RetrofitChallongeApiCall.this.errorUtil.parseException(response);
                    }
                    catch (ChallongeException | IOException e) {
                        callback.handleFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                callback.handleFailure(t);
            }
        });
    }
}

