/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.retrofit;

import com.exsoloscript.challonge.library.squareup.retrofit2.Call;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.Body;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.DELETE;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.GET;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.POST;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.PUT;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.Path;
import com.exsoloscript.challonge.library.squareup.retrofit2.http.Query;
import com.exsoloscript.challonge.model.Tournament;
import com.exsoloscript.challonge.model.enumeration.TournamentType;
import com.exsoloscript.challonge.model.enumeration.query.TournamentQueryState;
import com.exsoloscript.challonge.model.query.TournamentQuery;
import java.util.List;

public interface RetrofitTournamentHandler {
    @GET(value="tournaments.json")
    public Call<List<Tournament>> getTournaments(@Query(value="state") TournamentQueryState var1, @Query(value="type") TournamentType var2, @Query(value="created_after") String var3, @Query(value="created_before") String var4, @Query(value="subdomain") String var5);

    @GET(value="tournaments/{tournament}.json")
    public Call<Tournament> getTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments.json")
    public Call<Tournament> createTournament(@Body TournamentQuery var1);

    @PUT(value="tournaments/{tournament}.json")
    public Call<Tournament> updateTournament(@Path(value="tournament") String var1, @Body TournamentQuery var2);

    @DELETE(value="tournaments/{tournament}.json")
    public Call<Tournament> deleteTournament(@Path(value="tournament") String var1);

    @POST(value="tournaments/{tournament}/process_check_ins.json")
    public Call<Tournament> processCheckIns(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/abort_check_in.json")
    public Call<Tournament> abortCheckIn(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/start.json")
    public Call<Tournament> startTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/finalize.json")
    public Call<Tournament> finalizeTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/reset.json")
    public Call<Tournament> resetTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);
}

