/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.common.util.concurrent;

import com.exsoloscript.challonge.library.google.common.annotations.GwtCompatible;
import com.exsoloscript.challonge.library.google.common.annotations.GwtIncompatible;
import com.exsoloscript.challonge.library.google.common.base.Preconditions;
import com.exsoloscript.challonge.library.google.common.base.Supplier;
import com.exsoloscript.challonge.library.javax.annotation.Nullable;
import java.util.concurrent.Callable;

@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(final @Nullable T value) {
        return new Callable<T>(){

            @Override
            public T call() {
                return value;
            }
        };
    }

    @GwtIncompatible(value="threads")
    static <T> Callable<T> threadRenaming(final Callable<T> callable, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (restoreName) {
                        Callables.trySetName(oldName, currentThread);
                    }
                }
            }
        };
    }

    @GwtIncompatible(value="threads")
    static Runnable threadRenaming(final Runnable task, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
                try {
                    task.run();
                }
                finally {
                    if (restoreName) {
                        Callables.trySetName(oldName, currentThread);
                    }
                }
            }
        };
    }

    @GwtIncompatible(value="threads")
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

