/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.inject.internal;

import com.exsoloscript.challonge.library.google.common.base.Preconditions;
import com.exsoloscript.challonge.library.google.inject.Key;
import com.exsoloscript.challonge.library.google.inject.internal.ConstructionContext;
import com.exsoloscript.challonge.library.google.inject.internal.CreationListener;
import com.exsoloscript.challonge.library.google.inject.internal.Errors;
import com.exsoloscript.challonge.library.google.inject.internal.ErrorsException;
import com.exsoloscript.challonge.library.google.inject.internal.InjectorImpl;
import com.exsoloscript.challonge.library.google.inject.internal.InternalContext;
import com.exsoloscript.challonge.library.google.inject.internal.InternalFactory;
import com.exsoloscript.challonge.library.google.inject.internal.ProviderInternalFactory;
import com.exsoloscript.challonge.library.google.inject.internal.ProvisionListenerStackCallback;
import com.exsoloscript.challonge.library.google.inject.spi.Dependency;
import com.exsoloscript.challonge.library.javax.inject.Provider;

final class BoundProviderFactory<T>
extends ProviderInternalFactory<T>
implements CreationListener {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injector, Key<? extends Provider<? extends T>> providerKey, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = Preconditions.checkNotNull(provisionCallback, "provisionCallback");
        this.injector = injector;
        this.providerKey = providerKey;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        context.pushState(this.providerKey, this.source);
        try {
            errors = errors.withSource(this.providerKey);
            Provider<? extends T> provider = this.providerFactory.get(errors, context, dependency, true);
            T t = this.circularGet(provider, errors, context, dependency, this.provisionCallback);
            return t;
        }
        finally {
            context.popState();
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            return super.provision(provider, errors, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw errors.errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

