/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.inject.internal;

import com.exsoloscript.challonge.library.google.common.collect.ImmutableList;
import com.exsoloscript.challonge.library.google.common.collect.Iterables;
import com.exsoloscript.challonge.library.google.inject.internal.ConstructorInjector;
import com.exsoloscript.challonge.library.google.inject.internal.Errors;
import com.exsoloscript.challonge.library.google.inject.internal.ErrorsException;
import com.exsoloscript.challonge.library.google.inject.internal.FailableCache;
import com.exsoloscript.challonge.library.google.inject.internal.InjectorImpl;
import com.exsoloscript.challonge.library.google.inject.internal.MembersInjectorImpl;
import com.exsoloscript.challonge.library.google.inject.internal.MethodAspect;
import com.exsoloscript.challonge.library.google.inject.internal.ProxyFactory;
import com.exsoloscript.challonge.library.google.inject.internal.SingleParameterInjector;
import com.exsoloscript.challonge.library.google.inject.spi.InjectionPoint;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ImmutableList<MethodAspect> injectorAspects = this.injector.state.getMethodAspects();
        ImmutableList<MethodAspect> methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : ImmutableList.copyOf(Iterables.concat(injectorAspects, membersInjector.getAddedAspects()));
        ProxyFactory factory = new ProxyFactory(injectionPoint, methodAspects);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

