/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk;

import com.fangcloud.sdk.YfyClient;
import com.fangcloud.sdk.YfyRefreshListener;
import com.fangcloud.sdk.YfyRequestConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class YfyClientFactory<T> {
    private YfyRequestConfig requestConfig;
    private YfyRefreshListener<T> refreshListener;
    private volatile Map<T, YfyClient<T>> lruCache;

    public YfyClientFactory(int maxCapacity, YfyRequestConfig requestConfig, YfyRefreshListener<T> refreshListener) {
        if (requestConfig == null) {
            throw new NullPointerException("request config");
        }
        this.lruCache = new LRULinkedHashMap<T, YfyClient<T>>(maxCapacity);
        this.requestConfig = requestConfig;
        this.refreshListener = refreshListener;
    }

    public YfyClientFactory(int maxCapacity, YfyRequestConfig requestConfig) {
        this(maxCapacity, requestConfig, null);
    }

    public Map<T, YfyClient<T>> getLruCache() {
        return this.lruCache;
    }

    public YfyClient getClient(T key) {
        return this.lruCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public YfyClient getClient(T key, String accessToken, String refreshToken) {
        YfyClient<T> client = this.lruCache.get(key);
        if (client != null) return client;
        Class<YfyClientFactory> clazz = YfyClientFactory.class;
        synchronized (YfyClientFactory.class) {
            client = this.lruCache.get(key);
            if (client != null) return client;
            client = new YfyClient<T>(key, this.requestConfig, accessToken, refreshToken, this.refreshListener);
            this.lruCache.put(key, client);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return client;
        }
    }

    private class LRULinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final int maxCapacity;
        private ReadWriteLock lock;

        public LRULinkedHashMap(int maxCapacity) {
            super((int)Math.ceil((float)maxCapacity / 0.75f) + 1, 0.75f, true);
            this.maxCapacity = maxCapacity;
            this.lock = new ReentrantReadWriteLock();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCapacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            this.lock.readLock().lock();
            try {
                Object v = super.get(key);
                return v;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            this.lock.writeLock().lock();
            try {
                V v = super.put(key, value);
                return v;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

