/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.auth;

import com.fangcloud.sdk.YfyAppInfo;
import com.fangcloud.sdk.YfyRequestConfig;
import com.fangcloud.sdk.YfyRequestUtil;
import com.fangcloud.sdk.YfySessionStore;
import com.fangcloud.sdk.auth.YfyAuthFinish;
import com.fangcloud.sdk.exception.YfyException;
import com.fangcloud.sdk.util.StringUtil;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class YfyWebAuth {
    private static final SecureRandom RAND = new SecureRandom();
    private static final int CSRF_BYTES_SIZE = 16;
    private static final int CSRF_STRING_SIZE = StringUtil.urlSafeBase64Encode(new byte[16]).length();
    private final YfyRequestConfig requestConfig;

    public YfyWebAuth(YfyRequestConfig requestConfig) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        this.requestConfig = requestConfig;
    }

    public String authorize(Request request) {
        return this.authorizeImpl(request);
    }

    private String authorizeImpl(Request request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", YfyAppInfo.getKey());
        params.put("response_type", "code");
        if (request.redirectUri != null) {
            params.put("redirect_uri", request.redirectUri);
            params.put("state", YfyWebAuth.appendCsrfToken(request));
        }
        return YfyRequestUtil.buildUrlWithParams(YfyAppInfo.getHost().getAuth(), "oauth/authorize", params);
    }

    private static String appendCsrfToken(Request request) {
        byte[] csrf = new byte[16];
        RAND.nextBytes(csrf);
        String prefix = StringUtil.urlSafeBase64Encode(csrf);
        if (prefix.length() != CSRF_STRING_SIZE) {
            throw new AssertionError((Object)("unexpected CSRF token length: " + prefix.length()));
        }
        if (request.sessionStore != null) {
            request.sessionStore.set(prefix);
        }
        String state = prefix;
        if (request.state != null && (state = prefix + request.state).length() > 500) {
            throw new AssertionError((Object)("unexpected combined state length: " + state.length()));
        }
        if (request.sessionStore != null) {
            request.sessionStore.set(state);
        }
        return state;
    }

    public YfyAuthFinish finishFromRedirect(String redirectUri, YfySessionStore sessionStore, Map<String, String[]> params) throws YfyException, BadRequestException, BadStateException, CsrfException {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri");
        }
        if (sessionStore == null) {
            throw new NullPointerException("sessionStore");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        String state = this.getParam(params, "state");
        if (state == null) {
            throw new BadRequestException("Missing required parameter: \"state\".");
        }
        String code = this.getParam(params, "code");
        if (code == null) {
            throw new BadRequestException("Missing \"code\".");
        }
        YfyWebAuth.verifyAndStripCsrfToken(state, sessionStore);
        return this.finish(code, redirectUri);
    }

    public YfyAuthFinish finishFromCode(String code) throws YfyException {
        return this.finish(code, null);
    }

    public YfyAuthFinish passwordLogin(String username, String password) throws YfyException {
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "password");
        params.put("username", username);
        params.put("password", password);
        return YfyRequestUtil.doPostInAuth(this.requestConfig, YfyAppInfo.getHost().getAuth(), "oauth/token", params, YfyAuthFinish.class);
    }

    private String getParam(Map<String, String[]> params, String name) throws BadRequestException {
        String[] v = params.get(name);
        if (v == null) {
            return null;
        }
        if (v.length == 0) {
            throw new IllegalArgumentException("Parameter \"" + name + "\" missing value.");
        }
        if (v.length == 1) {
            return v[0];
        }
        throw new BadRequestException("multiple occurrences of \"" + name + "\" parameter");
    }

    private static void verifyAndStripCsrfToken(String state, YfySessionStore sessionStore) throws CsrfException, BadStateException {
        String expected = sessionStore.get();
        if (expected == null) {
            throw new BadStateException("No CSRF Token loaded from session store.");
        }
        if (expected.length() < CSRF_STRING_SIZE) {
            throw new BadStateException("Token retrieved from session store is too small: " + expected);
        }
        if (state.length() < CSRF_STRING_SIZE) {
            throw new CsrfException("Token too small: " + state);
        }
        if (!StringUtil.secureStringEquals(expected, state)) {
            throw new CsrfException("expecting " + StringUtil.jq(expected) + ", got " + StringUtil.jq(state));
        }
    }

    private YfyAuthFinish finish(String code, String redirectUri) throws YfyException {
        if (code == null) {
            throw new NullPointerException("code");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        if (redirectUri != null) {
            params.put("redirect_uri", redirectUri);
        }
        return YfyRequestUtil.doPostInAuth(this.requestConfig, YfyAppInfo.getHost().getAuth(), "oauth/token", params, YfyAuthFinish.class);
    }

    public static Request.Builder newRequestBuilder() {
        return Request.newBuilder();
    }

    public static final class Request {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private static final int MAX_STATE_SIZE = 500;
        private final String redirectUri;
        private final String state;
        private final YfySessionStore sessionStore;

        private Request(String redirectUri, String state, YfySessionStore sessionStore) {
            this.redirectUri = redirectUri;
            this.state = state;
            this.sessionStore = sessionStore;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private String redirectUri;
            private String state;
            private YfySessionStore sessionStore;

            public Builder withNoRedirect() {
                this.redirectUri = null;
                this.sessionStore = null;
                return this;
            }

            public Builder withRedirectUri(String redirectUri, YfySessionStore sessionStore) {
                if (redirectUri == null) {
                    throw new NullPointerException("redirectUri");
                }
                if (sessionStore == null) {
                    throw new NullPointerException("sessionStore");
                }
                this.redirectUri = redirectUri;
                this.sessionStore = sessionStore;
                return this;
            }

            public Builder withState(String state) {
                if (state != null && state.getBytes(UTF8).length + CSRF_STRING_SIZE > 500) {
                    throw new IllegalArgumentException("UTF-8 encoded state cannot be greater than " + (500 - CSRF_STRING_SIZE) + " bytes.");
                }
                this.state = state;
                return this;
            }

            public Request build() {
                if (this.redirectUri == null && this.state != null) {
                    throw new IllegalStateException("Cannot specify a state without a redirect URI.");
                }
                return new Request(this.redirectUri, this.state, this.sessionStore);
            }
        }
    }

    public static final class CsrfException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public CsrfException(String message) {
            super(message);
        }
    }

    public static final class BadStateException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public BadStateException(String message) {
            super(message);
        }
    }

    public static final class BadRequestException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public BadRequestException(String message) {
            super(message);
        }
    }
}

