/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk;

import com.fangcloud.sdk.YfyHost;
import com.fangcloud.sdk.util.StringUtil;

public class YfyAppInfo {
    private static final String TEST_FLAG = "FangcloudTest";
    private static String key;
    private static String secret;
    private static YfyHost host;

    private YfyAppInfo() {
    }

    public static void initAppInfo(String key, String secret) {
        YfyHost host = YfyHost.DEFAULT;
        if (System.getenv().get(TEST_FLAG) != null) {
            host = new YfyHost("platform.fangcloud.net", "oauth-server.fangcloud.net");
        }
        YfyAppInfo.initAppInfo(key, secret, host);
    }

    private static void initAppInfo(String key, String secret, YfyHost host) {
        YfyAppInfo.checkKeyArg(key);
        YfyAppInfo.checkSecretArg(secret);
        YfyAppInfo.key = key;
        YfyAppInfo.secret = secret;
        YfyAppInfo.host = host;
    }

    public static String getKey() {
        YfyAppInfo.checkKeyArg(key);
        return key;
    }

    public static String getSecret() {
        YfyAppInfo.checkSecretArg(secret);
        return secret;
    }

    public static YfyHost getHost() {
        return host;
    }

    public static String getTokenPartError(String s) {
        if (s == null) {
            return "can't be null";
        }
        if (s.length() == 0) {
            return "can't be empty";
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return "invalid character at index " + i + ": " + StringUtil.jq("" + c);
        }
        return null;
    }

    public static void checkKeyArg(String key) {
        String error = YfyAppInfo.getTokenPartError(key);
        if (error == null) {
            return;
        }
        throw new IllegalArgumentException("app info not init 'key': " + error);
    }

    public static void checkSecretArg(String secret) {
        String error = YfyAppInfo.getTokenPartError(secret);
        if (error == null) {
            return;
        }
        throw new IllegalArgumentException("app info not init 'secret': " + error);
    }
}

