/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.file;

import com.fangcloud.sdk.YfyAppInfo;
import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.YfyProgressListener;
import com.fangcloud.sdk.api.SuccessResult;
import com.fangcloud.sdk.api.YfyFileVersion;
import com.fangcloud.sdk.api.comment.ListCommentResult;
import com.fangcloud.sdk.api.file.CopyFileArg;
import com.fangcloud.sdk.api.file.DeleteFileArg;
import com.fangcloud.sdk.api.file.DeleteFileFromTrashArg;
import com.fangcloud.sdk.api.file.GetPreviewTokenArg;
import com.fangcloud.sdk.api.file.ListFileVersionsResult;
import com.fangcloud.sdk.api.file.MoveFileArg;
import com.fangcloud.sdk.api.file.NewVersionPreSignatureUploadArg;
import com.fangcloud.sdk.api.file.PreSignatureDownloadResult;
import com.fangcloud.sdk.api.file.PreSignatureUploadArg;
import com.fangcloud.sdk.api.file.PreSignatureUploadResult;
import com.fangcloud.sdk.api.file.PreviewTokenResult;
import com.fangcloud.sdk.api.file.RestoreFileFromTrashArg;
import com.fangcloud.sdk.api.file.UpdateFileArg;
import com.fangcloud.sdk.api.file.YfyFile;
import com.fangcloud.sdk.api.share_link.ListShareLinkResult;
import com.fangcloud.sdk.exception.NetworkIOException;
import com.fangcloud.sdk.exception.YfyException;
import com.fangcloud.sdk.util.IOUtil;
import com.fangcloud.sdk.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class YfyFileRequest {
    private static final String FILE_API_PATH = "api/v2/file/";
    private static final String GET_FILE_PATH = "api/v2/file/%s/info";
    private static final String COPY_FILE_PATH = "api/v2/file/%s/copy";
    private static final String PRE_SIGNATURE_DOWNLOAD_PATH = "api/v2/file/%s/download";
    private static final String PRE_SIGNATURE_UPLOAD_PATH = "api/v2/file/upload";
    private static final String NEW_VERSION_PRE_SIGNATURE_UPLOAD_PATH = "api/v2/file/%s/new_version";
    private static final String UPDATE_FILE_PATH = "api/v2/file/%s/update";
    private static final String DELETE_FILE_PATH = "api/v2/file/%s/delete";
    private static final String DELETE_FILE_BATCH_PATH = "api/v2/file/delete_batch";
    private static final String DELETE_FILE_FROM_TRASH_PATH = "api/v2/file/%s/delete_from_trash";
    private static final String DELETE_FILE_BATCH_FROM_TRASH_PATH = "api/v2/file/delete_batch_from_trash";
    private static final String RESTORE_FILE_FROM_TRASH_PATH = "api/v2/file/%s/restore_from_trash";
    private static final String RESTORE_FILE_BATCH_FROM_TRASH_PATH = "api/v2/file/restore_batch_from_trash";
    private static final String MOVE_FILE_PATH = "api/v2/file/%s/move";
    private static final String MOVE_FILE_BATCH_PATH = "api/v2/file/move_batch";
    private static final String PREVIEW_PATH = "api/v2/file/%s/preview";
    private static final String DOWNLOAD_PREVIEW_PATH = "api/v2/file/%s/preview_download";
    private static final String LIST_FILE_SHARE_LINK_PATH = "api/v2/file/%s/share_links";
    private static final String LIST_COMMENT_PATH = "api/v2/file/%s/comments";
    private static final String LIST_VERSION_PATH = "api/v2/file/%s/versions";
    private static final String GET_VERSION_PATH = "api/v2/file/%s/version/%s/info";
    private static final String GET_PREVIEW_TOKEN_PATH = "api/v2/file//preview_token";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyFileRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyFile getFile(long fileId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.getFile(params);
    }

    private YfyFile getFile(String[] params) throws YfyException {
        return this.client.doGet(GET_FILE_PATH, params, null, YfyFile.class);
    }

    public YfyFile updateFile(long fileId, String newName, String newDescription) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.updateFile(params, new UpdateFileArg(newName, newDescription));
    }

    private YfyFile updateFile(String[] params, UpdateFileArg updateFileArg) throws YfyException {
        return this.client.doPost(UPDATE_FILE_PATH, params, updateFileArg, YfyFile.class);
    }

    public SuccessResult deleteFile(long fileId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.deleteFile(DELETE_FILE_PATH, params, null);
    }

    private SuccessResult deleteFile(String path, String[] params, DeleteFileArg deleteFileArg) throws YfyException {
        return this.client.doPost(path, params, deleteFileArg, SuccessResult.class);
    }

    public SuccessResult deleteFileFromTrash(long fileId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.deleteFileFromTrash(DELETE_FILE_FROM_TRASH_PATH, params, null);
    }

    private SuccessResult deleteFileFromTrash(String path, String[] params, DeleteFileFromTrashArg deleteFileFromTrashArg) throws YfyException {
        return this.client.doPost(path, params, deleteFileFromTrashArg, SuccessResult.class);
    }

    public SuccessResult restoreFileFromTrash(long fileId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.restoreFileFromTrash(RESTORE_FILE_FROM_TRASH_PATH, params, null);
    }

    private SuccessResult restoreFileFromTrash(String path, String[] params, RestoreFileFromTrashArg restoreFileFromTrashArg) throws YfyException {
        return this.client.doPost(path, params, restoreFileFromTrashArg, SuccessResult.class);
    }

    public SuccessResult moveFile(long fileId, long targetFolderId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.moveFile(MOVE_FILE_PATH, params, new MoveFileArg(null, targetFolderId));
    }

    private SuccessResult moveFile(String path, String[] params, MoveFileArg moveFileArg) throws YfyException {
        return this.client.doPost(path, params, moveFileArg, SuccessResult.class);
    }

    public String preSignatureDownload(long fileId) throws YfyException {
        String[] params = new String[]{String.valueOf(fileId)};
        return this.preSignatureDownload(params).getDownloadUrl();
    }

    private PreSignatureDownloadResult preSignatureDownload(String[] params) throws YfyException {
        return this.client.doGet(PRE_SIGNATURE_DOWNLOAD_PATH, params, null, PreSignatureDownloadResult.class);
    }

    public void downloadFile(String downloadUrl, String savePath) throws YfyException {
        InputStream body = this.client.doDownload(downloadUrl, false, null);
        File file = new File(savePath);
        try {
            IOUtil.copyStreamToFile(body, file);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
        finally {
            IOUtil.closeQuietly(body);
        }
    }

    public void downloadFile(String downloadUrl, String savePath, YfyProgressListener progressListener) throws YfyException {
        InputStream body = this.client.doDownload(downloadUrl, false, progressListener);
        File file = new File(savePath);
        try {
            IOUtil.copyStreamToFile(body, file);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
        finally {
            IOUtil.closeQuietly(body);
        }
    }

    public InputStream downloadFileStream(String downloadUrl) throws YfyException {
        return this.client.doDownload(downloadUrl, false, null);
    }

    public InputStream downloadFileStream(String downloadUrl, YfyProgressListener progressListener) throws YfyException {
        return this.client.doDownload(downloadUrl, false, progressListener);
    }

    public void directDownloadFile(long fileId, String savePath) throws YfyException {
        this.downloadFile(this.preSignatureDownload(fileId), savePath);
    }

    public InputStream directDownloadFileStream(long fileId) throws YfyException {
        return this.downloadFileStream(this.preSignatureDownload(fileId));
    }

    public String preSignatureUpload(long parentId, String name) throws YfyException {
        StringUtil.checkStringNotEmpty(name);
        return this.preSignatureUpload(new PreSignatureUploadArg(parentId, name, "api")).getUploadUrl();
    }

    private PreSignatureUploadResult preSignatureUpload(PreSignatureUploadArg preSignatureUploadArg) throws YfyException {
        return this.client.doPost(PRE_SIGNATURE_UPLOAD_PATH, null, preSignatureUploadArg, PreSignatureUploadResult.class);
    }

    public String newVersionPreSignatureUpload(long fileId, String name, String remark) throws YfyException {
        StringUtil.checkStringNotEmpty(name);
        String[] param = new String[]{String.valueOf(fileId)};
        return this.newVersionPreSignatureUpload(param, new NewVersionPreSignatureUploadArg(name, "api", remark)).getUploadUrl();
    }

    private PreSignatureUploadResult newVersionPreSignatureUpload(String[] param, NewVersionPreSignatureUploadArg newVersionPreSignatureUploadArg) throws YfyException {
        return this.client.doPost(NEW_VERSION_PRE_SIGNATURE_UPLOAD_PATH, param, newVersionPreSignatureUploadArg, PreSignatureUploadResult.class);
    }

    public YfyFile uploadFile(String uploadUrl, String filePath) throws YfyException, FileNotFoundException {
        StringUtil.checkStringNotEmpty(uploadUrl);
        StringUtil.checkStringNotEmpty(filePath);
        return this.client.doUpload(uploadUrl, new FileInputStream(filePath), 0L, null);
    }

    public YfyFile uploadFile(String uploadUrl, String filePath, long fileSize, YfyProgressListener progressListener) throws YfyException, FileNotFoundException {
        StringUtil.checkStringNotEmpty(uploadUrl);
        StringUtil.checkStringNotEmpty(filePath);
        return this.client.doUpload(uploadUrl, new FileInputStream(filePath), fileSize, progressListener);
    }

    public YfyFile uploadFile(String uploadUrl, InputStream fileStream) throws YfyException {
        StringUtil.checkStringNotEmpty(uploadUrl);
        StringUtil.checkObjectNotNull(fileStream);
        return this.client.doUpload(uploadUrl, fileStream, 0L, null);
    }

    public YfyFile uploadFile(String uploadUrl, InputStream fileStream, long fileSize, YfyProgressListener progressListener) throws YfyException {
        StringUtil.checkStringNotEmpty(uploadUrl);
        StringUtil.checkObjectNotNull(fileStream);
        return this.client.doUpload(uploadUrl, fileStream, fileSize, progressListener);
    }

    public YfyFile directUploadFile(long parentId, String name, String filePath) throws YfyException, FileNotFoundException {
        return this.uploadFile(this.preSignatureUpload(parentId, name), filePath);
    }

    public YfyFile directUploadFile(long parentId, String name, InputStream fileStream) throws YfyException {
        return this.uploadFile(this.preSignatureUpload(parentId, name), fileStream);
    }

    public YfyFile directUploadNewVersionFile(long fileId, String name, String remark, String filePath) throws YfyException, FileNotFoundException {
        return this.uploadFile(this.newVersionPreSignatureUpload(fileId, name, remark), filePath);
    }

    public YfyFile directUploadNewVersionFile(long fileId, String name, String remark, InputStream fileStream) throws YfyException {
        return this.uploadFile(this.newVersionPreSignatureUpload(fileId, name, remark), fileStream);
    }

    public YfyFile copyFile(long fileId, long targetFolderId) throws YfyException {
        String[] param = new String[]{String.valueOf(fileId)};
        return this.copyFile(param, new CopyFileArg(targetFolderId));
    }

    private YfyFile copyFile(String[] param, CopyFileArg copyFileArg) throws YfyException {
        return this.client.doPost(COPY_FILE_PATH, param, copyFileArg, YfyFile.class);
    }

    public ListShareLinkResult listShareLink(long fileId, final int pageId) throws YfyException {
        String[] param = new String[]{String.valueOf(fileId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
            }
        };
        return this.listShareLink(param, (Map<String, String>)mapParams);
    }

    public ListShareLinkResult listShareLink(long fileId, final int pageId, final long ownerId) throws YfyException {
        String[] param = new String[]{String.valueOf(fileId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
                this.put("owner_id", String.valueOf(ownerId));
            }
        };
        return this.listShareLink(param, (Map<String, String>)mapParams);
    }

    private ListShareLinkResult listShareLink(String[] param, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(LIST_FILE_SHARE_LINK_PATH, param, mapParams, ListShareLinkResult.class);
    }

    public ListCommentResult listComment(long fileId) throws YfyException {
        String[] param = new String[]{String.valueOf(fileId)};
        return this.listComment(param);
    }

    private ListCommentResult listComment(String[] param) throws YfyException {
        return this.client.doGet(LIST_COMMENT_PATH, param, null, ListCommentResult.class);
    }

    public ListFileVersionsResult listVersions(long fileId) throws YfyException {
        Object[] param = new String[]{String.valueOf(fileId)};
        return this.client.doGet(LIST_VERSION_PATH, param, null, ListFileVersionsResult.class);
    }

    public YfyFileVersion getFileVersion(long fileId, long fileVersionId) throws YfyException {
        Object[] param = new String[]{String.valueOf(fileId), String.valueOf(fileVersionId)};
        return this.client.doGet(GET_VERSION_PATH, param, null, YfyFileVersion.class);
    }

    public String getPreviewUrl(long fileId, int period) throws YfyException {
        PreviewTokenResult result = this.client.doPost(GET_PREVIEW_TOKEN_PATH, null, new GetPreviewTokenArg(fileId, period), PreviewTokenResult.class);
        return "https://" + YfyAppInfo.getHost().getApi() + "/preview/preview.html?preview_token=" + result.getPreviewToken();
    }

    public String getPreviewUrl(long fileId, long fileVersionId, int period) throws YfyException {
        PreviewTokenResult result = this.client.doPost(GET_PREVIEW_TOKEN_PATH, null, new GetPreviewTokenArg(fileId, fileVersionId, period), PreviewTokenResult.class);
        return "https://" + YfyAppInfo.getHost().getApi() + "/preview/preview.html?preview_token=" + result.getPreviewToken();
    }
}

