/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.folder;

import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.api.ItemTypeEnum;
import com.fangcloud.sdk.api.SuccessResult;
import com.fangcloud.sdk.api.collab.ListCollabResult;
import com.fangcloud.sdk.api.folder.CreateFolderArg;
import com.fangcloud.sdk.api.folder.DeleteFolderArg;
import com.fangcloud.sdk.api.folder.DeleteFolderFromTrashArg;
import com.fangcloud.sdk.api.folder.GetChildrenResult;
import com.fangcloud.sdk.api.folder.GetCollabFoldersResult;
import com.fangcloud.sdk.api.folder.MoveFolderArg;
import com.fangcloud.sdk.api.folder.RestoreFolderFromTrashArg;
import com.fangcloud.sdk.api.folder.UpdateFolderArg;
import com.fangcloud.sdk.api.folder.YfyFolder;
import com.fangcloud.sdk.api.share_link.ListShareLinkResult;
import com.fangcloud.sdk.exception.YfyException;
import java.util.HashMap;
import java.util.Map;

public class YfyFolderRequest {
    private static final String FOLDER_API_PATH = "api/v2/folder/";
    private static final String GET_PERSONAL_ITEMS_PATH = "api/v2/folder/personal_items";
    private static final String GET_DEPARTMENT_FOLDERS_PATH = "api/v2/folder/department_folders";
    private static final String GET_CHILDREN_PATH = "api/v2/folder/%s/children";
    private static final String GET_COLLAB_FOLDER_PATH = "api/v2/folder/collab_folders";
    private static final String CREATE_FOLDER_PATH = "api/v2/folder/create";
    private static final String GET_FOLDER_PATH = "api/v2/folder/%s/info";
    private static final String UPDATE_FOLDER_PATH = "api/v2/folder/%s/update";
    private static final String DELETE_FOLDER_PATH = "api/v2/folder/%s/delete";
    private static final String DELETE_FOLDER_BATCH_PATH = "api/v2/folder/delete_batch";
    private static final String DELETE_FOLDER_FROM_TRASH_PATH = "api/v2/folder/%s/delete_from_trash";
    private static final String DELETE_FOLDER_BATCH_FROM_TRASH_PATH = "api/v2/folder/delete_batch_from_trash";
    private static final String RESTORE_FOLDER_FROM_TRASH_PATH = "api/v2/folder/%s/restore_from_trash";
    private static final String RESTORE_FOLDER_BATCH_FROM_TRASH_PATH = "api/v2/folder/restore_batch_from_trash";
    private static final String MOVE_FOLDER_PATH = "api/v2/folder/%s/move";
    private static final String MOVE_FOLDER_BATCH_PATH = "api/v2/folder/move_batch";
    private static final String LIST_FOLDER_SHARE_LINK_PATH = "api/v2/folder/%s/share_links";
    private static final String LIST_COLLAB_PATH = "api/v2/folder/%s/collabs";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyFolderRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyFolder getFolder(long folderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.getFolder(param);
    }

    private YfyFolder getFolder(String[] param) throws YfyException {
        return this.client.doGet(GET_FOLDER_PATH, param, null, YfyFolder.class);
    }

    public YfyFolder createFolder(String name, long parentId) throws YfyException {
        return this.createFolder(name, parentId, null);
    }

    public YfyFolder createFolder(String name, long parentId, Long departmentId) throws YfyException {
        return this.createFolder(new CreateFolderArg(name, parentId, departmentId));
    }

    private YfyFolder createFolder(CreateFolderArg createFolderArg) throws YfyException {
        return this.client.doPost(CREATE_FOLDER_PATH, null, createFolderArg, YfyFolder.class);
    }

    public YfyFolder updateFolder(long folderId, String newName) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.updateFolder(param, new UpdateFolderArg(newName));
    }

    private YfyFolder updateFolder(String[] param, UpdateFolderArg updateFolderArg) throws YfyException {
        return this.client.doPost(UPDATE_FOLDER_PATH, param, updateFolderArg, YfyFolder.class);
    }

    public SuccessResult deleteFolder(long folderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.deleteFolder(DELETE_FOLDER_PATH, param, null);
    }

    private SuccessResult deleteFolder(String path, String[] param, DeleteFolderArg deleteFolderArg) throws YfyException {
        return this.client.doPost(path, param, deleteFolderArg, SuccessResult.class);
    }

    public SuccessResult deleteFolderFromTrash(long folderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.deleteFolderFromTrash(DELETE_FOLDER_FROM_TRASH_PATH, param, null);
    }

    private SuccessResult deleteFolderFromTrash(String path, String[] param, DeleteFolderFromTrashArg deleteFolderFromTrashArg) throws YfyException {
        return this.client.doPost(path, param, deleteFolderFromTrashArg, SuccessResult.class);
    }

    public SuccessResult restoreFolderFromTrash(long folderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.restoreFolderFromTrash(RESTORE_FOLDER_FROM_TRASH_PATH, param, null);
    }

    private SuccessResult restoreFolderFromTrash(String path, String[] param, RestoreFolderFromTrashArg restoreFolderFromTrashArg) throws YfyException {
        return this.client.doPost(path, param, restoreFolderFromTrashArg, SuccessResult.class);
    }

    public SuccessResult moveFolder(long folderId, long targetFolderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.moveFolder(MOVE_FOLDER_PATH, param, new MoveFolderArg(null, targetFolderId));
    }

    private SuccessResult moveFolder(String path, String[] param, MoveFolderArg moveFolderArg) throws YfyException {
        return this.client.doPost(path, param, moveFolderArg, SuccessResult.class);
    }

    public GetChildrenResult getChildren(long folderId, final int pageId, final int pageCapacity, final ItemTypeEnum itemType) throws YfyException {
        String[] params = new String[]{String.valueOf(folderId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
                this.put("page_capacity", String.valueOf(pageCapacity));
                this.put("type", itemType.getType());
            }
        };
        return this.getChildren(params, (Map<String, String>)mapParams);
    }

    public GetChildrenResult getPersonalItems(final int pageId, final int pageCapacity, final ItemTypeEnum itemType) throws YfyException {
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
                this.put("page_capacity", String.valueOf(pageCapacity));
                this.put("type", itemType.getType());
            }
        };
        return this.client.doGet(GET_PERSONAL_ITEMS_PATH, null, (Map<String, String>)mapParams, GetChildrenResult.class);
    }

    public GetChildrenResult getDepartmentFolders(final long departmentId, final int pageId, final int pageCapacity, final ItemTypeEnum itemType) throws YfyException {
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("department_id", String.valueOf(departmentId));
                this.put("page_id", String.valueOf(pageId));
                this.put("page_capacity", String.valueOf(pageCapacity));
                this.put("type", itemType.getType());
            }
        };
        return this.client.doGet(GET_DEPARTMENT_FOLDERS_PATH, null, (Map<String, String>)mapParams, GetChildrenResult.class);
    }

    private GetChildrenResult getChildren(String[] params, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(GET_CHILDREN_PATH, params, mapParams, GetChildrenResult.class);
    }

    public GetCollabFoldersResult getCollabFolders(final int pageId, final int pageCapacity) throws YfyException {
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
                this.put("page_capacity", String.valueOf(pageCapacity));
            }
        };
        return this.getCollabFolders((Map<String, String>)mapParams);
    }

    private GetCollabFoldersResult getCollabFolders(Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(GET_COLLAB_FOLDER_PATH, null, mapParams, GetCollabFoldersResult.class);
    }

    public ListShareLinkResult listShareLink(long folderId, final int pageId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
            }
        };
        return this.listShareLink(param, (Map<String, String>)mapParams);
    }

    public ListShareLinkResult listShareLink(long folderId, final int pageId, final long ownerId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("page_id", String.valueOf(pageId));
                this.put("owner_id", String.valueOf(ownerId));
            }
        };
        return this.listShareLink(param, (Map<String, String>)mapParams);
    }

    private ListShareLinkResult listShareLink(String[] param, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(LIST_FOLDER_SHARE_LINK_PATH, param, mapParams, ListShareLinkResult.class);
    }

    public ListCollabResult listCollab(long folderId) throws YfyException {
        String[] param = new String[]{String.valueOf(folderId)};
        return this.listCollab(param);
    }

    private ListCollabResult listCollab(String[] param) throws YfyException {
        return this.client.doGet(LIST_COLLAB_PATH, param, null, ListCollabResult.class);
    }
}

