/*
 * Decompiled with CFR 0.152.
 */
package express.middleware;

import express.filter.Filter;
import express.filter.FilterTask;
import express.http.Cookie;
import express.http.HttpRequestHandler;
import express.http.SessionCookie;
import express.http.request.Request;
import express.http.response.Response;
import express.utils.Utils;
import java.util.concurrent.ConcurrentHashMap;

final class CookieSession
implements HttpRequestHandler,
Filter,
FilterTask {
    private static final String MIDDLEWARE_NAME = "sessioncookie";
    private final ConcurrentHashMap<String, SessionCookie> cookies = new ConcurrentHashMap();
    private final String cookieName;
    private final long maxAge;

    CookieSession(String cookieName, long maxAge) {
        this.cookieName = cookieName;
        this.maxAge = maxAge;
    }

    @Override
    public void handle(Request req, Response res) {
        Cookie cookie = req.getCookie(this.cookieName);
        if (cookie != null && this.cookies.containsKey(cookie.getValue())) {
            req.addMiddlewareContent(this, this.cookies.get(cookie.getValue()));
        } else {
            String token;
            while (this.cookies.contains(token = Utils.randomToken(32, 16))) {
            }
            cookie = new Cookie(this.cookieName, token).setMaxAge(this.maxAge);
            res.setCookie(cookie);
            SessionCookie sessionCookie = new SessionCookie(this.maxAge);
            this.cookies.put(token, sessionCookie);
            req.addMiddlewareContent(this, sessionCookie);
        }
    }

    @Override
    public String getName() {
        return MIDDLEWARE_NAME;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
        this.cookies.clear();
    }

    @Override
    public long getDelay() {
        return 60000L;
    }

    @Override
    public void onUpdate() {
        long current = System.currentTimeMillis();
        this.cookies.forEach((cookieHash, cookie) -> {
            if (current > cookie.getCreated() + cookie.getMaxAge()) {
                this.cookies.remove(cookieHash);
            }
        });
    }
}

