/*
 * Decompiled with CFR 0.152.
 */
package com.github.andyczy.java.excel;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsUtils {
    private static Logger log = LoggerFactory.getLogger(CommonsUtils.class);
    private static final String DataValidationError1 = "Excel\u8868\u683c\u63d0\u9192\uff1a";
    private static final String DataValidationError2 = "\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u8bf7\u9009\u62e9\u8868\u683c\u4e0b\u62c9\u5217\u8868\u4e2d\u7684\u6570\u636e\uff01";
    public static final Integer MAX_ROWSUM = 1048570;
    public static final Integer MAX_ROWSYTLE = 100000;

    public static void setDataList(SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap styles, HashMap paneMap, String[] sheetName, String[] labelName, HashMap rowStyles, HashMap columnStyles, HashMap dropDownMap) throws Exception {
        if (dataLists == null) {
            log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aExport data(type:List<List<String[]>>) cannot be empty!");
        }
        if (sheetName == null) {
            log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aExport sheet(type:String[]) name cannot be empty!");
        }
        int k = 0;
        for (List<String[]> listRow : dataLists) {
            SXSSFSheet sxssfSheet = wb.createSheet();
            sxssfSheet.setDefaultColumnWidth(16);
            wb.setSheetName(k, sheetName[k]);
            CellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = (XSSFFont)wb.createFont();
            int jRow = 0;
            if (labelName != null) {
                sxssfRow = sxssfSheet.createRow(0);
                Cell cell = CellUtil.createCell((Row)sxssfRow, (int)0, (String)labelName[k]);
                CommonsUtils.setMergedRegion(sxssfSheet, 0, 0, 0, listRow.get(0).length - 1);
                CommonsUtils.setLabelStyles(wb, cell, sxssfRow);
                jRow = 1;
            }
            Integer pane = 1;
            if (paneMap != null && paneMap.get(k + 1) != null) {
                pane = (Integer)paneMap.get(k + 1) + (labelName != null ? 1 : 0);
                CommonsUtils.createFreezePane(sxssfSheet, pane);
            }
            if (regionMap != null) {
                CommonsUtils.setMergedRegion(sxssfSheet, (ArrayList)regionMap.get(k + 1));
            }
            if (dropDownMap != null) {
                CommonsUtils.setDataValidation(sxssfSheet, (List)dropDownMap.get(k + 1), listRow.size());
            }
            if (columnMap != null) {
                CommonsUtils.setColumnWidth(sxssfSheet, (HashMap)columnMap.get(k + 1));
            }
            CommonsUtils.setStyle(cellStyle, font);
            CellStyle cell_style = null;
            CellStyle row_style = null;
            CellStyle column_style = null;
            Integer SIZE = listRow.size() < MAX_ROWSUM ? listRow.size() : MAX_ROWSUM.intValue();
            Integer MAXSYTLE = listRow.size() < MAX_ROWSYTLE ? listRow.size() : MAX_ROWSYTLE.intValue();
            for (int i = 0; i < SIZE; ++i) {
                sxssfRow = sxssfSheet.createRow(jRow);
                for (int j = 0; j < listRow.get(i).length; ++j) {
                    Cell cell = CellUtil.createCell((Row)sxssfRow, (int)j, (String)listRow.get(i)[j]);
                    cell.setCellStyle(cellStyle);
                    try {
                        if (columnStyles != null && jRow >= pane && i <= MAXSYTLE) {
                            if (jRow == pane && j == 0) {
                                column_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                            }
                            CommonsUtils.setExcelRowStyles(cell, column_style, wb, sxssfRow, (List)columnStyles.get(k + 1), j);
                        }
                        if (rowStyles != null && i <= MAXSYTLE) {
                            if (i == 0 && j == 0) {
                                row_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                            }
                            CommonsUtils.setExcelRowStyles(cell, row_style, wb, sxssfRow, (List)rowStyles.get(k + 1), jRow);
                        }
                        if (styles == null || i > MAXSYTLE) continue;
                        if (i == 0) {
                            cell_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                        }
                        CommonsUtils.setExcelStyles(cell, cell_style, wb, sxssfRow, (List)styles.get(k + 1), j, i);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aThe maximum number of cell styles was exceeded. You can define up to 4000 styles!");
                    }
                }
                ++jRow;
            }
            ++k;
        }
    }

    public static void setExcelStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, Integer fontSize, Boolean bold, Boolean center, Boolean isBorder, Boolean leftBoolean, Boolean rightBoolean, Integer fontColor, Integer height) {
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        if (center != null && center.booleanValue()) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        if (rightBoolean != null && rightBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        if (leftBoolean != null && leftBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        if (isBorder != null && isBorder.booleanValue()) {
            CommonsUtils.setBorder(cellStyle, isBorder);
        }
        XSSFFont font = (XSSFFont)wb.createFont();
        if (bold != null && bold.booleanValue()) {
            font.setBold(bold.booleanValue());
        }
        if (height != null) {
            sxssfRow.setHeight((short)(height * 2));
        }
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeight(fontSize == null ? 12.0 : (double)fontSize.intValue());
        cellStyle.setFont((Font)font);
        font.setColor(IndexedColors.fromInt((int)(fontColor == null ? 8 : fontColor.intValue())).index);
        cell.setCellStyle(cellStyle);
    }

    public static void setExcelRowStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<Object[]> rowstyleList, int rowIndex) {
        if (rowstyleList != null && rowstyleList.size() > 0) {
            Integer[] rowstyle = (Integer[])rowstyleList.get(1);
            for (int i = 0; i < rowstyle.length; ++i) {
                if (rowIndex != rowstyle[i]) continue;
                Boolean[] bool = (Boolean[])rowstyleList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (rowstyleList.size() >= 3) {
                    int leng = rowstyleList.get(2).length;
                    if (leng >= 1) {
                        fontColor = (Integer)rowstyleList.get(2)[0];
                    }
                    if (leng >= 2) {
                        fontSize = (Integer)rowstyleList.get(2)[1];
                    }
                    if (leng >= 3) {
                        height = (Integer)rowstyleList.get(2)[2];
                    }
                }
                CommonsUtils.setExcelStyles(cell, cellStyle, wb, sxssfRow, fontSize, (boolean)bool[3], (boolean)bool[0], (boolean)bool[4], (boolean)bool[2], (boolean)bool[1], fontColor, height);
            }
        }
    }

    public static void setDataListNoStyle(SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap paneMap, String[] sheetName, String[] labelName, HashMap dropDownMap) throws Exception {
        if (dataLists == null) {
            log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aExport data(type:List<List<String[]>>) cannot be empty!");
        }
        if (sheetName == null) {
            log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aExport sheet(type:String[]) name cannot be empty!");
        }
        int k = 0;
        for (List<String[]> listRow : dataLists) {
            SXSSFSheet sxssfSheet = wb.createSheet();
            wb.setSheetName(k, sheetName[k]);
            CellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = (XSSFFont)wb.createFont();
            int jRow = 0;
            if (labelName != null) {
                sxssfRow = sxssfSheet.createRow(0);
                Cell cell = CellUtil.createCell((Row)sxssfRow, (int)0, (String)labelName[k]);
                CommonsUtils.setMergedRegion(sxssfSheet, 0, 0, 0, listRow.get(0).length - 1);
                CommonsUtils.setLabelStyles(wb, cell, sxssfRow);
                jRow = 1;
            }
            Integer pane = 1;
            if (paneMap != null && paneMap.get(k + 1) != null) {
                pane = (Integer)paneMap.get(k + 1) + (labelName != null ? 1 : 0);
                CommonsUtils.createFreezePane(sxssfSheet, pane);
            }
            if (regionMap != null) {
                CommonsUtils.setMergedRegion(sxssfSheet, (ArrayList)regionMap.get(k + 1));
            }
            if (dropDownMap != null) {
                CommonsUtils.setDataValidation(sxssfSheet, (List)dropDownMap.get(k + 1), listRow.size());
            }
            if (columnMap != null) {
                CommonsUtils.setColumnWidth(sxssfSheet, (HashMap)columnMap.get(k + 1));
            }
            CommonsUtils.setStyle(cellStyle, font);
            Integer SIZE = listRow.size() < MAX_ROWSUM ? listRow.size() : MAX_ROWSUM.intValue();
            for (int i = 0; i < SIZE; ++i) {
                sxssfRow = sxssfSheet.createRow(jRow);
                for (int j = 0; j < listRow.get(i).length; ++j) {
                    Cell cell = CellUtil.createCell((Row)sxssfRow, (int)j, (String)listRow.get(i)[j]);
                    cell.setCellStyle(cellStyle);
                }
                ++jRow;
            }
            ++k;
        }
    }

    public static void writeAndColse(SXSSFWorkbook sxssfWorkbook, OutputStream outputStream) throws Exception {
        try {
            if (outputStream != null) {
                sxssfWorkbook.write(outputStream);
                sxssfWorkbook.dispose();
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Exception e) {
            System.out.println(" Andyczy ExcelUtils Exception Message\uff1aOutput stream is not empty !");
            e.getSuppressed();
        }
    }

    public static void setExcelStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<Object[]>> styles, int cellIndex, int rowIndex) {
        if (styles != null) {
            for (int z = 0; z < styles.size(); ++z) {
                List<Object[]> stylesList = styles.get(z);
                if (stylesList == null) continue;
                Boolean[] bool = (Boolean[])stylesList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (stylesList.size() >= 2) {
                    int leng = stylesList.get(1).length;
                    if (leng >= 1) {
                        fontColor = (Integer)stylesList.get(1)[0];
                    }
                    if (leng >= 2) {
                        fontSize = (Integer)stylesList.get(1)[1];
                    }
                    if (leng >= 3) {
                        height = (Integer)stylesList.get(1)[2];
                    }
                }
                for (int m = 2; m < stylesList.size(); ++m) {
                    Integer[] str = (Integer[])stylesList.get(m);
                    if (cellIndex + 1 != str[1] || rowIndex + 1 != str[0]) continue;
                    CommonsUtils.setExcelStyles(cell, cellStyle, wb, sxssfRow, fontSize, (boolean)bool[3], (boolean)bool[0], (boolean)bool[4], (boolean)bool[2], (boolean)bool[1], fontColor, height);
                }
            }
        }
    }

    public static void setLabelStyles(SXSSFWorkbook wb, Cell cell, SXSSFRow sxssfRow) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CommonsUtils.setBorder(cellStyle, true);
        sxssfRow.setHeight((short)798);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeight(16.0);
        cellStyle.setFont((Font)font);
        cell.setCellStyle(cellStyle);
    }

    public static void setStyle(CellStyle cellStyle, XSSFFont font) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont((Font)font);
        font.setFontHeight(12.0);
        CommonsUtils.setBorder(cellStyle, true);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void createFreezePane(SXSSFSheet sxssfSheet, Integer row) {
        if (row != null && row > 0) {
            sxssfSheet.createFreezePane(0, row.intValue(), 0, 1);
        }
    }

    public static void setColumnWidth(SXSSFSheet sxssfSheet, HashMap map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                sxssfSheet.setColumnWidth(((Integer)key).intValue(), (Integer)val * 512);
            }
        }
    }

    public static void setMergedRegion(SXSSFSheet sheet, ArrayList<Integer[]> rowColList) {
        if (rowColList != null && rowColList.size() > 0) {
            for (int i = 0; i < rowColList.size(); ++i) {
                Integer[] str = rowColList.get(i);
                if (str.length <= 0 || str.length != 4) continue;
                Integer firstRow = str[0];
                Integer lastRow = str[1];
                Integer firstCol = str[2];
                Integer lastCol = str[3];
                CommonsUtils.setMergedRegion(sheet, firstRow, lastRow, firstCol, lastCol);
            }
        }
    }

    public static void setMergedRegion(SXSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public static void setDataValidation(SXSSFSheet sheet, List<String[]> dropDownListData, int dataListSize) {
        if (dropDownListData.size() > 0) {
            for (int col = 0; col < dropDownListData.get(0).length; ++col) {
                Integer colv = Integer.parseInt(dropDownListData.get(0)[col]);
                CommonsUtils.setDataValidation(sheet, dropDownListData.get(col + 1), 1, dataListSize < 100 ? 500 : dataListSize, colv, colv);
            }
        }
    }

    public static void setDataValidation(SXSSFSheet xssfWsheet, String[] list, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        DataValidationHelper helper = xssfWsheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
        DataValidationConstraint constraint = helper.createExplicitListConstraint(list);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createErrorBox(DataValidationError1, DataValidationError2);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        xssfWsheet.addValidationData(dataValidation);
    }

    public static void setBorder(CellStyle cellStyle, Boolean isBorder) {
        if (isBorder.booleanValue()) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
        }
    }

    public static boolean verificationDate(String strDate, String style) {
        Object date = null;
        if (style == null) {
            style = "yyyy-MM-dd";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(style);
        try {
            formatter.parse(strDate);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String strToDateFormat(String strDate, String style, String expectDateFormatStr) {
        Date date = null;
        if (style == null) {
            style = "yyyy-MM-dd";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(style);
        try {
            date = formatter.parse(strDate);
        }
        catch (Exception e) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(expectDateFormatStr == null ? style : expectDateFormatStr);
        String str = sdf.format(date);
        return str;
    }
}

