/*
 * Decompiled with CFR 0.152.
 */
package com.github.andyczy.java.excel;

import com.github.andyczy.java.excel.CommonsUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExcelUtils {
    private static Logger log = LoggerFactory.getLogger(LocalExcelUtils.class);
    private static final ThreadLocal<SimpleDateFormat> fmt = new ThreadLocal();
    private static final ThreadLocal<DecimalFormat> df = new ThreadLocal();
    private static final ThreadLocal<LocalExcelUtils> UTILS_THREAD_LOCAL = new ThreadLocal();
    private static final Integer DATE_LENGTH = 10;
    private List<List<String[]>> dataLists;
    private String[] sheetName;
    private String[] labelName;
    private HashMap notBorderMap;
    private HashMap regionMap;
    private HashMap mapColumnWidth;
    private HashMap styles;
    private HashMap paneMap;
    private HashMap rowStyles;
    private HashMap columnStyles;
    private HashMap dropDownMap;
    private String fileName;
    private String filePath = this.getFilePath();
    private String numeralFormat;
    private String dateFormatStr;
    private String expectDateFormatStr;

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = fmt.get();
        if (format == null) {
            format = new SimpleDateFormat(this.expectDateFormatStr, Locale.getDefault());
            fmt.set(format);
        }
        return format;
    }

    public DecimalFormat getDecimalFormat() {
        DecimalFormat format = df.get();
        if (format == null) {
            format = new DecimalFormat(this.numeralFormat);
            df.set(format);
        }
        return format;
    }

    public static final LocalExcelUtils initialization() {
        LocalExcelUtils excelUtils = UTILS_THREAD_LOCAL.get();
        if (excelUtils == null) {
            excelUtils = new LocalExcelUtils();
            UTILS_THREAD_LOCAL.set(excelUtils);
        }
        return excelUtils;
    }

    public LocalExcelUtils() {
        this.dataLists = this.getDataLists();
        this.notBorderMap = this.getNotBorderMap();
        this.regionMap = this.getRegionMap();
        this.mapColumnWidth = this.getMapColumnWidth();
        this.styles = this.getStyles();
        this.paneMap = this.getPaneMap();
        this.fileName = this.getFileName();
        this.sheetName = this.getSheetName();
        this.labelName = this.getLabelName();
        this.rowStyles = this.getRowStyles();
        this.columnStyles = this.getColumnStyles();
        this.dropDownMap = this.getDropDownMap();
        this.numeralFormat = this.getNumeralFormat();
        this.dateFormatStr = this.getDateFormatStr();
        this.expectDateFormatStr = this.getExpectDateFormatStr();
    }

    public Boolean localNoStyleNoResponse() {
        long startTime = System.currentTimeMillis();
        log.info("=== ===  === :Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        SXSSFRow sxssfRow = null;
        try {
            CommonsUtils.setDataListNoStyle(sxssfWorkbook, sxssfRow, this.dataLists, this.notBorderMap, this.regionMap, this.mapColumnWidth, this.paneMap, this.sheetName, this.labelName, this.dropDownMap);
            LocalExcelUtils.setIo(sxssfWorkbook, this.filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("=== ===  === :Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    public Boolean localNoResponse() {
        long startTime = System.currentTimeMillis();
        log.info("=== ===  === :Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        SXSSFRow sxssfRow = null;
        try {
            CommonsUtils.setDataList(sxssfWorkbook, sxssfRow, this.dataLists, this.notBorderMap, this.regionMap, this.mapColumnWidth, this.styles, this.paneMap, this.sheetName, this.labelName, this.rowStyles, this.columnStyles, this.dropDownMap);
            LocalExcelUtils.setIo(sxssfWorkbook, this.filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("=== ===  === :Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    public static List<List<LinkedHashMap<String, String>>> importForExcelData(Workbook book, String[] sheetName, HashMap indexMap, HashMap continueRowMap) {
        long startTime = System.currentTimeMillis();
        log.info("=== ===  === :Excel tool class export start run!");
        try {
            ArrayList<List<LinkedHashMap<String, String>>> returnDataList = new ArrayList<List<LinkedHashMap<String, String>>>();
            for (int k = 0; k <= sheetName.length - 1; ++k) {
                Sheet sheet = book.getSheetAt(k);
                int rowCount = sheet.getLastRowNum() + 1;
                Row valueRow = null;
                ArrayList rowListValue = new ArrayList();
                LinkedHashMap<String, String> cellHashMap = null;
                int irow = 1;
                if (indexMap != null && indexMap.get(k + 1) != null) {
                    irow = Integer.valueOf(indexMap.get(k + 1).toString()) - 1;
                }
                for (int i = irow; i < rowCount; ++i) {
                    valueRow = sheet.getRow(i);
                    if (valueRow == null) continue;
                    if (continueRowMap != null && continueRowMap.get(k + 1) != null) {
                        int continueRowCount = 0;
                        Integer[] continueRow = (Integer[])continueRowMap.get(k + 1);
                        for (int w = 0; w <= continueRow.length - 1; ++w) {
                            Cell valueRowCell = valueRow.getCell(continueRow[w] - 1);
                            if (valueRowCell != null && !CommonsUtils.isBlank(valueRowCell.toString())) continue;
                            ++continueRowCount;
                        }
                        if (continueRowCount == continueRow.length) continue;
                    }
                    cellHashMap = new LinkedHashMap<String, String>();
                    for (int j = 0; j < valueRow.getLastCellNum(); ++j) {
                        cellHashMap.put(Integer.toString(j), LocalExcelUtils.getCellVal(valueRow.getCell(j)));
                    }
                    if (cellHashMap.size() <= 0) continue;
                    rowListValue.add(cellHashMap);
                }
                returnDataList.add(rowListValue);
            }
            log.info("=== ===  === :Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
            return returnDataList;
        }
        catch (Exception e) {
            log.debug("=== ===  === :Andyczy ExcelUtils Exception Message\uff1aExcel tool class export exception !");
            e.printStackTrace();
            return null;
        }
    }

    private static void setIo(SXSSFWorkbook sxssfWorkbook, String filePath) throws Exception {
        FileOutputStream outputStream = null;
        try {
            if (filePath != null && (outputStream = new FileOutputStream(filePath)) != null) {
                sxssfWorkbook.write((OutputStream)outputStream);
                sxssfWorkbook.dispose();
                outputStream.flush();
                ((OutputStream)outputStream).close();
            }
        }
        catch (Exception e) {
            e.getSuppressed();
        }
    }

    private static String getCellVal(Cell cell) {
        String val = null;
        if (cell != null) {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        val = LocalExcelUtils.initialization().getDateFormat().format(cell.getDateCellValue());
                        break;
                    }
                    val = LocalExcelUtils.initialization().getDecimalFormat().format(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    if (cell.getStringCellValue().trim().length() >= DATE_LENGTH && CommonsUtils.verificationDate(cell.getStringCellValue(), LocalExcelUtils.initialization().dateFormatStr)) {
                        val = CommonsUtils.strToDateFormat(cell.getStringCellValue(), LocalExcelUtils.initialization().dateFormatStr, LocalExcelUtils.initialization().expectDateFormatStr);
                        break;
                    }
                    val = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    val = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    val = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    val = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    try {
                        val = String.valueOf(cell.getStringCellValue());
                    }
                    catch (IllegalStateException e) {
                        val = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                default: {
                    val = cell.getRichStringCellValue() == null ? null : cell.getRichStringCellValue().toString();
                    break;
                }
            }
        } else {
            val = "";
        }
        return val;
    }

    public void setDateFormatStr(String dateFormatStr) {
        if (dateFormatStr == null) {
            dateFormatStr = "yyyy-MM-dd";
        }
        this.dateFormatStr = dateFormatStr;
    }

    public String getDateFormatStr() {
        if (this.dateFormatStr == null) {
            this.dateFormatStr = "yyyy-MM-dd";
        }
        return this.dateFormatStr;
    }

    public String getExpectDateFormatStr() {
        if (this.expectDateFormatStr == null) {
            this.expectDateFormatStr = this.dateFormatStr;
        }
        return this.expectDateFormatStr;
    }

    public void setExpectDateFormatStr(String expectDateFormatStr) {
        if (expectDateFormatStr == null) {
            expectDateFormatStr = this.dateFormatStr;
        }
        this.expectDateFormatStr = expectDateFormatStr;
    }

    public void setNumeralFormat(String numeralFormat) {
        if (numeralFormat == null) {
            numeralFormat = "#.######";
        }
        this.numeralFormat = numeralFormat;
    }

    public String getNumeralFormat() {
        if (this.numeralFormat == null) {
            this.numeralFormat = "#.######";
        }
        return this.numeralFormat;
    }

    public List<List<String[]>> getDataLists() {
        return this.dataLists;
    }

    public void setDataLists(List<List<String[]>> dataLists) {
        this.dataLists = dataLists;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public String[] getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String[] labelName) {
        this.labelName = labelName;
    }

    public HashMap getNotBorderMap() {
        return this.notBorderMap;
    }

    public void setNotBorderMap(HashMap notBorderMap) {
        this.notBorderMap = notBorderMap;
    }

    public HashMap getRegionMap() {
        return this.regionMap;
    }

    public void setRegionMap(HashMap regionMap) {
        this.regionMap = regionMap;
    }

    public HashMap getMapColumnWidth() {
        return this.mapColumnWidth;
    }

    public void setMapColumnWidth(HashMap mapColumnWidth) {
        this.mapColumnWidth = mapColumnWidth;
    }

    public HashMap getStyles() {
        return this.styles;
    }

    public void setStyles(HashMap styles) {
        this.styles = styles;
    }

    public HashMap getPaneMap() {
        return this.paneMap;
    }

    public void setPaneMap(HashMap paneMap) {
        this.paneMap = paneMap;
    }

    public HashMap getRowStyles() {
        return this.rowStyles;
    }

    public void setRowStyles(HashMap rowStyles) {
        this.rowStyles = rowStyles;
    }

    public HashMap getColumnStyles() {
        return this.columnStyles;
    }

    public void setColumnStyles(HashMap columnStyles) {
        this.columnStyles = columnStyles;
    }

    public HashMap getDropDownMap() {
        return this.dropDownMap;
    }

    public void setDropDownMap(HashMap dropDownMap) {
        this.dropDownMap = dropDownMap;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

