/*
 * Copyright 2018 Anton Straka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sk.antons.json.literal.impl;

import sk.antons.json.literal.JsonBoolLiteral;

/**
 *
 * @author antons
 */
public class JsonBoolLiteralImpl extends JsonLiteralImpl implements JsonBoolLiteral {
    
    private boolean cachedValue = false;
    private boolean cachedValueBool = false;
    
    public JsonBoolLiteralImpl(boolean value) {
        super(String.valueOf(value));
    }

    public JsonBoolLiteralImpl(String literal, int offset, int length) {
        super(literal, offset, length);
    }

    @Override
    public Type type() { return Type.BOOL; }
    
    public boolean boolValue() {
        if(cachedValue) return cachedValueBool;
        cachedValueBool = "true".equals(stringValue());
        cachedValue = true;
        return cachedValueBool;
    }
}
