/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.limiter;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import sk.antons.web.filter.limiter.Limiter;
import sk.antons.web.filter.limiter.PathConf;
import sk.antons.web.filter.limiter.ResponseStatusCheck;
import sk.antons.web.filter.limiter.StringConf;
import sk.antons.web.filter.limiter.StringConfReader;

public class RequestLimiter
implements Limiter {
    private Limiter custom = null;
    private PathConf pathconf = new PathConf<RequestLimiter>(this);
    private StringConf ipconf = new StringConf<RequestLimiter>(this);
    private StringConf hostconf = new StringConf<RequestLimiter>(this);
    private StringConf contenttypeconf = new StringConf<RequestLimiter>(this);
    private ResponseStatusCheck responseStatusCheck = null;

    public PathConf path() {
        return this.pathconf;
    }

    public StringConf host() {
        return this.hostconf;
    }

    public StringConf contentType() {
        return this.contenttypeconf;
    }

    public RequestLimiter custom(Limiter limiter) {
        this.custom = limiter;
        return this;
    }

    public RequestLimiter responseStatus(ResponseStatusCheck check) {
        this.responseStatusCheck = check;
        return this;
    }

    public RequestLimiter reset() {
        this.pathconf = new PathConf<RequestLimiter>(this);
        this.ipconf = new StringConf<RequestLimiter>(this);
        this.hostconf = new StringConf<RequestLimiter>(this);
        this.contenttypeconf = new StringConf<RequestLimiter>(this);
        return this;
    }

    @Override
    public boolean allow(ServletRequest request) {
        String value;
        if (request == null) {
            return false;
        }
        if (this.custom != null && !this.custom.allow(request)) {
            return false;
        }
        if (request instanceof HttpServletRequest) {
            String method;
            HttpServletRequest httprequest = (HttpServletRequest)request;
            String ip = httprequest.getRemoteAddr();
            String host = httprequest.getRemoteHost();
            String contenttype = httprequest.getContentType();
            String path = httprequest.getRequestURI();
            if (!RequestLimiter.pathAllow(this.pathconf, path, method = httprequest.getMethod(), ip, host, contenttype)) {
                return false;
            }
        }
        if (!RequestLimiter.stringAllow(this.contenttypeconf, value = request.getContentType())) {
            return false;
        }
        value = request.getRemoteAddr();
        if (!RequestLimiter.stringAllow(this.ipconf, value)) {
            return false;
        }
        value = request.getRemoteHost();
        return RequestLimiter.stringAllow(this.ipconf, value);
    }

    @Override
    public boolean allowResponseStatus(ServletRequest request, int status) {
        if (status <= 0) {
            return true;
        }
        if (request == null) {
            return false;
        }
        if (this.custom != null && !this.custom.allowResponseStatus(request, status)) {
            return false;
        }
        if (request instanceof HttpServletRequest) {
            String method;
            HttpServletRequest httprequest = (HttpServletRequest)request;
            String ip = httprequest.getRemoteAddr();
            String host = httprequest.getRemoteHost();
            String contenttype = httprequest.getContentType();
            String path = httprequest.getRequestURI();
            if (!RequestLimiter.pathAllowResponseStatus(this.pathconf, path, method = httprequest.getMethod(), ip, host, contenttype, status)) {
                return false;
            }
        }
        if (this.responseStatusCheck != null) {
            return this.responseStatusCheck.allow(status);
        }
        return true;
    }

    private static boolean pathAllow(PathConf conf, String path, String method, String ip, String host, String contenttype) {
        PathConf.Combo matcher;
        if (conf.includes.isEmpty()) {
            if (conf.excludes.isEmpty()) {
                return true;
            }
            for (PathConf.Combo o : conf.excludes) {
                PathConf.Combo matcher2 = o;
                if (!matcher2.match(path, method, ip, host, contenttype)) continue;
                return false;
            }
            return true;
        }
        boolean rv = false;
        for (PathConf.Combo o : conf.includes) {
            matcher = o;
            if (!matcher.match(path, method, ip, host, contenttype)) continue;
            rv = true;
            break;
        }
        if (!rv) {
            return false;
        }
        if (conf.excludes.isEmpty()) {
            return true;
        }
        for (PathConf.Combo o : conf.excludes) {
            matcher = o;
            if (!matcher.match(path, method, ip, host, contenttype)) continue;
            return false;
        }
        return true;
    }

    private static boolean pathAllowResponseStatus(PathConf conf, String path, String method, String ip, String host, String contenttype, int status) {
        PathConf.Combo matcher;
        if (conf.includes.isEmpty()) {
            if (conf.excludes.isEmpty()) {
                return true;
            }
            for (PathConf.Combo o : conf.excludes) {
                PathConf.Combo matcher2 = o;
                if (!matcher2.match(path, method, ip, host, contenttype) || !matcher2.match(status)) continue;
                return false;
            }
            return true;
        }
        boolean rv = false;
        for (PathConf.Combo o : conf.includes) {
            matcher = o;
            if (!matcher.match(path, method, ip, host, contenttype) || !matcher.match(status)) continue;
            rv = true;
            break;
        }
        if (!rv) {
            return false;
        }
        if (conf.excludes.isEmpty()) {
            return true;
        }
        for (PathConf.Combo o : conf.excludes) {
            matcher = o;
            if (!matcher.match(path, method, ip, host, contenttype) || !matcher.match(status)) continue;
            return false;
        }
        return true;
    }

    private static boolean stringAllow(StringConf conf, String value) {
        return StringConfReader.allow(conf, value);
    }
}

