/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sk.antons.json.util.JsonFormat;
import sk.antons.web.filter.limiter.RequestLimiter;
import sk.antons.web.filter.log.Consumer;
import sk.antons.web.filter.log.ConsumerStatus;
import sk.antons.web.filter.log.Jsonable;
import sk.antons.web.filter.log.LogConsumer;
import sk.antons.web.filter.log.LogConsumerStatus;
import sk.antons.web.filter.log.Printable;
import sk.antons.web.filter.log.SimpleJsonable;
import sk.antons.web.filter.log.SimplePrintable;
import sk.antons.web.filter.util.HttpServletRequestWrapper;
import sk.antons.web.filter.util.HttpServletResponseWrapper;
import sk.antons.web.filter.util.ServletRequestWrapper;
import sk.antons.web.filter.util.ServletResponseWrapper;

public class LogFilter
implements Filter {
    private RequestLimiter limiter = new RequestLimiter();
    private Consumer consumer = new LogConsumer();
    private ConsumerStatus consumerStatus = new LogConsumerStatus();
    private Printable printable = new SimplePrintable();
    private Jsonable jsonable = new SimpleJsonable();
    private boolean logHeaders = true;
    private boolean logPayload = true;
    private boolean forceOneLine = true;
    private int truncateTo = 0;
    private int truncateLineTo = 0;
    private int truncateJsonelementTo = 0;
    private String requestBeforePrefix = "REQ";
    private String requestPrefix = "REQ";
    private String responsePrefix = "RES";
    private static long requestId = 1L;

    public static LogFilter instance() {
        return new LogFilter();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.consumerStatus.isConsumerOn() && this.limiter.allow(request)) {
            this.doFilterInternal(LogFilter.wrapRequest(request), LogFilter.wrapResponse(response), chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }

    public RequestLimiter limit() {
        return this.limiter;
    }

    public LogFilter consumer(Consumer consumer, ConsumerStatus consumerStatus) {
        if (consumer == null) {
            throw new IllegalArgumentException("Consumer can't be null");
        }
        if (consumerStatus == null) {
            throw new IllegalArgumentException("ConsumerStatus can't be null");
        }
        this.consumer = consumer;
        this.consumerStatus = consumerStatus;
        return this;
    }

    public LogFilter printable(Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException("Printable can't be null");
        }
        this.printable = printable;
        return this;
    }

    public LogFilter jsonable(Jsonable jsonable) {
        if (jsonable == null) {
            throw new IllegalArgumentException("Jsonable can't be null");
        }
        this.jsonable = jsonable;
        return this;
    }

    public LogFilter headers(boolean value) {
        this.logHeaders = value;
        return this;
    }

    public LogFilter payloads(boolean value) {
        this.logPayload = value;
        return this;
    }

    public LogFilter oneLine(boolean value) {
        this.forceOneLine = value;
        return this;
    }

    public LogFilter truncateTo(int value) {
        this.truncateTo = value;
        return this;
    }

    public LogFilter truncateLineTo(int value) {
        this.truncateLineTo = value;
        return this;
    }

    public LogFilter truncateJsonLiteral(int value) {
        this.truncateJsonelementTo = value;
        return this;
    }

    public LogFilter requestBeforePrefix(String value) {
        this.requestBeforePrefix = value;
        return this;
    }

    public LogFilter requestPrefix(String value) {
        this.requestBeforePrefix = value;
        return this;
    }

    public LogFilter responsePrefix(String value) {
        this.requestBeforePrefix = value;
        return this;
    }

    protected void doFilterInternal(ServletRequestWrapper request, ServletResponseWrapper response, FilterChain filterChain) throws ServletException, IOException {
        StringBuilder pathbuff = new StringBuilder();
        StringBuilder requestheaderbuff = new StringBuilder();
        StringBuilder requestpayloadbuff = new StringBuilder();
        StringBuilder responseheadersbuff = new StringBuilder();
        StringBuilder responsepayloadbuff = new StringBuilder();
        int status = -1;
        int exceprionStatus = -1;
        long id = requestId++;
        long starttime = System.currentTimeMillis();
        try {
            if (this.consumerStatus.isConsumerOn()) {
                this.requestData(request, pathbuff, requestheaderbuff, requestpayloadbuff);
                if (this.requestBeforePrefix != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.requestBeforePrefix).append('[').append(id).append(']').append((CharSequence)pathbuff).append(" vvv");
                    this.consumer.consume(sb.toString());
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (response instanceof HttpServletResponseWrapper) {
                status = ((HttpServletResponseWrapper)response).getStatus();
            }
        }
        catch (Throwable t) {
            exceprionStatus = 500;
            if (this.consumerStatus.isConsumerOn()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.responsePrefix).append('[').append(id).append(']').append(" ServletException ").append((CharSequence)pathbuff).append(' ').append(t);
                this.consumer.consume(sb.toString());
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
        finally {
            if (this.consumerStatus.isConsumerOn()) {
                if (exceprionStatus > 0) {
                    status = exceprionStatus;
                }
                if (status <= 0 || this.limiter.allowResponseStatus(request, status)) {
                    StringBuilder sb;
                    this.responseData(response, responseheadersbuff, responsepayloadbuff);
                    long endtime = System.currentTimeMillis();
                    long time = endtime - starttime;
                    if (this.requestPrefix != null) {
                        sb = new StringBuilder();
                        sb.append(this.requestPrefix).append('[').append(id).append(']').append((CharSequence)pathbuff).append((CharSequence)requestheaderbuff).append((CharSequence)requestpayloadbuff);
                        this.consumer.consume(sb.toString());
                    }
                    if (this.responsePrefix != null) {
                        sb = new StringBuilder();
                        sb.append(this.responsePrefix).append('[').append(id).append(']').append((CharSequence)pathbuff);
                        sb.append(" status: ").append(status);
                        sb.append(" time: ").append(time).append((CharSequence)responseheadersbuff).append((CharSequence)responsepayloadbuff);
                        this.consumer.consume(sb.toString());
                    }
                }
            }
        }
    }

    private static ServletRequestWrapper wrapRequest(ServletRequest request) {
        if (request instanceof ServletRequestWrapper) {
            return (ServletRequestWrapper)request;
        }
        if (request instanceof HttpServletRequest) {
            return new HttpServletRequestWrapper((HttpServletRequest)request);
        }
        return new ServletRequestWrapper(request);
    }

    private static ServletResponseWrapper wrapResponse(ServletResponse response) {
        if (response instanceof ServletResponseWrapper) {
            return (ServletResponseWrapper)response;
        }
        if (response instanceof HttpServletResponse) {
            return new HttpServletResponseWrapper((HttpServletResponse)response);
        }
        return new ServletResponseWrapper(response);
    }

    protected void requestData(ServletRequestWrapper request, StringBuilder pathbuff, StringBuilder requestheaderbuff, StringBuilder requestpayloadbuff) {
        HttpServletRequestWrapper httprequest = null;
        if (request instanceof HttpServletRequestWrapper) {
            httprequest = (HttpServletRequestWrapper)request;
        }
        if (httprequest != null) {
            String method = httprequest.getMethod();
            String pathString = httprequest.getRequestURI();
            String queryString = httprequest.getQueryString();
            pathbuff.append(' ').append(method).append(' ').append(pathString);
            if (queryString != null) {
                pathbuff.append('?').append(queryString);
            }
        }
        if (this.logHeaders && httprequest != null) {
            Enumeration params;
            if (this.forceOneLine) {
                requestheaderbuff.append(' ').append(request.getProtocol());
                requestheaderbuff.append(" headers(");
                params = httprequest.getHeaderNames();
                boolean nofirst = false;
                while (params.hasMoreElements()) {
                    String param = (String)params.nextElement();
                    Enumeration values = httprequest.getHeaders(param);
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        if (nofirst) {
                            requestheaderbuff.append(", ");
                        } else {
                            nofirst = true;
                        }
                        requestheaderbuff.append(param).append(": ").append(value);
                    }
                }
                requestheaderbuff.append(")");
            } else {
                requestheaderbuff.append("\n-- header ------------------------ ");
                requestheaderbuff.append('\n').append(request.getProtocol());
                params = httprequest.getHeaderNames();
                while (params.hasMoreElements()) {
                    String param = (String)params.nextElement();
                    Enumeration values = httprequest.getHeaders(param);
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        requestheaderbuff.append('\n').append(param).append(": ").append(value);
                    }
                }
            }
        }
        if (this.logPayload) {
            boolean printable = this.printable.isPrintable(request.getContentType());
            boolean jsonable = this.jsonable.isJsonable(request.getContentType());
            int length = 0;
            ServletInputStream is = null;
            try {
                String text;
                block28: {
                    int num = 0;
                    byte[] data = new byte[1024];
                    is = request.getInputStream();
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    while ((num = is.read(data, 0, data.length)) != -1) {
                        length += num;
                        if (!printable) continue;
                        buffer.write(data, 0, num);
                    }
                    buffer.flush();
                    byte[] bytes = buffer.toByteArray();
                    text = "";
                    if (printable) {
                        text = new String(bytes, "utf-8");
                        if (jsonable && length > 0) {
                            if (this.forceOneLine) {
                                try {
                                    if (this.truncateJsonelementTo > 0) {
                                        text = JsonFormat.from((String)text).noindent().cutStringLiterals(this.truncateJsonelementTo).toText();
                                        break block28;
                                    }
                                    text = JsonFormat.from((String)text).noindent().toText();
                                }
                                catch (Exception exception) {}
                            }
                        } else if (this.truncateLineTo > 0 || this.truncateTo > 0 || this.forceOneLine) {
                            text = LogFilter.cut(text, this.truncateTo, this.truncateLineTo, this.forceOneLine);
                        }
                    }
                }
                if (this.forceOneLine) {
                    requestpayloadbuff.append(" payload[").append(text).append(']');
                    requestpayloadbuff.append("] size: ").append(length);
                } else {
                    requestpayloadbuff.append("\n-- payload ------------------------\n");
                    requestpayloadbuff.append(text);
                    requestpayloadbuff.append("\n size: ").append(length);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static boolean isSpace(char c) {
        if (c == ' ') {
            return true;
        }
        if (c == '\n') {
            return true;
        }
        if (c == '\t') {
            return true;
        }
        return c == '\r';
    }

    private static String cut(String value, int wholeLength, int onelineLength, boolean forceOneLine) {
        int startpos;
        if (value == null) {
            return value;
        }
        if (value.length() == 0) {
            return value;
        }
        if (wholeLength <= 0 && onelineLength <= 0 && !forceOneLine) {
            return value;
        }
        int endpos = value.length() - 1;
        for (startpos = 0; startpos <= endpos && LogFilter.isSpace(value.charAt(startpos)); ++startpos) {
        }
        while (endpos > startpos && LogFilter.isSpace(value.charAt(endpos))) {
            --endpos;
        }
        if (startpos >= endpos) {
            return "";
        }
        int oldPos = startpos;
        int pos = value.indexOf(10, oldPos);
        if (pos < 0 || pos > endpos) {
            if (value.length() < wholeLength) {
                return value;
            }
            value = value.substring(0, wholeLength - 13) + "... truncated";
            return value;
        }
        StringBuilder sb = new StringBuilder();
        while (pos >= 0) {
            if (sb.length() > 0) {
                if (forceOneLine) {
                    sb.append("\\n");
                } else {
                    sb.append('\n');
                }
            }
            if (onelineLength > 0 && pos - oldPos > onelineLength) {
                sb.append(value, oldPos, oldPos + onelineLength - 13);
                sb.append("... truncated");
            } else {
                sb.append(value, oldPos, pos);
            }
            oldPos = pos + 1;
            pos = value.indexOf(10, oldPos);
        }
        int len = value.length();
        if (oldPos < len) {
            if (onelineLength > 0 && pos - oldPos > onelineLength) {
                sb.append(value, oldPos, oldPos + onelineLength - 13);
                sb.append("... truncated");
            } else {
                sb.append(value, oldPos, len);
            }
        }
        if (wholeLength > 0 && sb.length() > wholeLength) {
            sb.setLength(wholeLength - 13);
            sb.append("... truncated");
        }
        return sb.toString();
    }

    protected void responseData(ServletResponseWrapper response, StringBuilder responseheadersbuff, StringBuilder responsepayloadbuff) {
        HttpServletResponseWrapper httpresponse = null;
        if (response instanceof HttpServletResponseWrapper) {
            httpresponse = (HttpServletResponseWrapper)response;
        }
        if (this.logHeaders && httpresponse != null) {
            Collection<String> params;
            if (this.forceOneLine) {
                responseheadersbuff.append(" headers(");
                params = httpresponse.getHeaderNames();
                boolean nofirst = false;
                for (String param : params) {
                    Collection<String> values = httpresponse.getHeaders(param);
                    Iterator<String> iterator = values.iterator();
                    while (iterator.hasNext()) {
                        String value = iterator.next();
                        if (nofirst) {
                            responseheadersbuff.append(", ");
                        } else {
                            nofirst = true;
                        }
                        responseheadersbuff.append(param).append(": ").append(value);
                    }
                }
                responseheadersbuff.append(")");
            } else {
                responseheadersbuff.append("\n-- header ------------------------ ");
                params = httpresponse.getHeaderNames();
                for (String param : params) {
                    Collection<String> values = httpresponse.getHeaders(param);
                    for (String value : values) {
                        responseheadersbuff.append('\n').append(param).append(": ").append(value);
                    }
                }
            }
        }
        if (this.logPayload) {
            boolean printable = this.printable.isPrintable(response.getContentType());
            boolean jsonable = this.jsonable.isJsonable(response.getContentType());
            int length = 0;
            InputStream is = null;
            try {
                String text;
                block31: {
                    is = response.getContentInputStream();
                    text = "";
                    byte[] bytes = null;
                    if (is != null) {
                        int num = 0;
                        byte[] data = new byte[1024];
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        while ((num = is.read(data, 0, data.length)) != -1) {
                            length += num;
                            if (!printable) continue;
                            buffer.write(data, 0, num);
                        }
                        buffer.flush();
                        bytes = buffer.toByteArray();
                    }
                    if (printable && bytes != null) {
                        text = new String(bytes, "utf-8");
                        if (jsonable && length > 0) {
                            if (this.forceOneLine) {
                                try {
                                    if (this.truncateJsonelementTo > 0) {
                                        text = JsonFormat.from((String)text).noindent().cutStringLiterals(this.truncateJsonelementTo).toText();
                                        break block31;
                                    }
                                    text = JsonFormat.from((String)text).noindent().toText();
                                }
                                catch (Exception exception) {}
                            } else {
                                try {
                                    if (this.truncateJsonelementTo > 0) {
                                        text = JsonFormat.from((String)text).cutStringLiterals(this.truncateJsonelementTo).toText();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        } else if (this.truncateLineTo > 0 || this.truncateTo > 0 || this.forceOneLine) {
                            text = LogFilter.cut(text, this.truncateTo, this.truncateLineTo, this.forceOneLine);
                        }
                    }
                }
                if (this.forceOneLine) {
                    responsepayloadbuff.append(" payload[").append(text).append(']');
                    responsepayloadbuff.append("] size: ").append(length);
                } else {
                    responsepayloadbuff.append("\n-- payload ------------------------\n");
                    responsepayloadbuff.append(text);
                    responsepayloadbuff.append("\n size: ").append(length);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

