/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class WriterTee
extends Writer {
    private Writer writer;
    private ByteArrayOutputStream bos;
    private Writer bwriter;

    public WriterTee(Writer is) {
        this.writer = this.writer;
        this.bos = new ByteArrayOutputStream();
        try {
            this.bwriter = new OutputStreamWriter((OutputStream)this.bos, "utf-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static WriterTee instance(Writer writer) {
        return new WriterTee(writer);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
        this.bwriter.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
        this.bwriter.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        this.bwriter.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
        this.bwriter.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
        this.bwriter.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.writer.append(csq);
        this.bwriter.append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.writer.append(csq, start, end);
        this.bwriter.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.writer.append(c);
        this.bwriter.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
        this.bwriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.bwriter.close();
    }

    public byte[] toByteArray() {
        return this.bos.toByteArray();
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.bos.toByteArray());
    }
}

