/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.limiter;

import java.util.ArrayList;
import java.util.List;
import sk.antons.web.filter.limiter.ResponseStatusCheck;
import sk.antons.web.path.PathMatcher;

public class PathConf<T> {
    private T parent = null;
    private int max = 64;
    protected List<Combo> includes = new ArrayList<Combo>();
    protected List<Combo> excludes = new ArrayList<Combo>();

    protected PathConf(T parent) {
        this.parent = parent;
    }

    public T and() {
        return this.parent;
    }

    public PathConf<T> reset(int max) {
        this.max = max;
        this.includes = new ArrayList<Combo>();
        this.excludes = new ArrayList<Combo>();
        return this;
    }

    public PathConf<T> include(String pattern) {
        return this.include(pattern, null);
    }

    public PathConf<T> include(String pattern, String method) {
        this.includes.add(Combo.instance(PathMatcher.instance((String)pattern, (int)this.max), method));
        return this;
    }

    public PathConf<T> include(String pattern, String method, String ip, String host, String contenttype, ResponseStatusCheck responseStatusCheck) {
        this.includes.add(Combo.instance(PathMatcher.instance((String)pattern, (int)this.max), method, ip, host, contenttype, responseStatusCheck));
        return this;
    }

    public PathConf<T> exclude(String pattern) {
        return this.exclude(pattern, null);
    }

    public PathConf<T> exclude(String pattern, String method) {
        this.excludes.add(Combo.instance(PathMatcher.instance((String)pattern, (int)this.max), method));
        return this;
    }

    public PathConf<T> exclude(String pattern, String method, String ip, String host, String contenttype, ResponseStatusCheck responseStatusCheck) {
        this.excludes.add(Combo.instance(PathMatcher.instance((String)pattern, (int)this.max), method, ip, host, contenttype, responseStatusCheck));
        return this;
    }

    protected static class Combo {
        private PathMatcher matcher;
        private String method;
        private String ip;
        private String host;
        private String contenttype;
        private ResponseStatusCheck responseStatusCheck = null;

        public Combo(PathMatcher matcher, String method) {
            this.matcher = matcher;
            this.method = method;
        }

        public Combo(PathMatcher matcher, String method, String ip, String host, String contenttype, ResponseStatusCheck responseStatusCheck) {
            this.matcher = matcher;
            this.method = method;
            this.ip = ip;
            this.host = host;
            this.contenttype = contenttype;
            this.responseStatusCheck = responseStatusCheck;
        }

        public static Combo instance(PathMatcher matcher, String method) {
            return new Combo(matcher, method);
        }

        public static Combo instance(PathMatcher matcher, String method, String ip, String host, String contenttype, ResponseStatusCheck responseStatusCheck) {
            return new Combo(matcher, method, ip, host, contenttype, responseStatusCheck);
        }

        public boolean match(int responseStatus) {
            if (responseStatus <= 0) {
                return true;
            }
            return this.responseStatusCheck == null || this.responseStatusCheck.allow(responseStatus);
        }

        public boolean match(String path, String method, String ip, String host, String contenttype) {
            if (this.matcher != null && !this.matcher.match(path)) {
                return false;
            }
            if (this.method != null && !this.method.equals(method)) {
                return false;
            }
            if (this.ip != null && !this.ip.equals(ip)) {
                return false;
            }
            if (this.host != null && !this.host.equals(host)) {
                return false;
            }
            return this.contenttype == null || this.contenttype.equals(contenttype);
        }
    }

    public static class ComboConf {
        private int max;
        private Combo combo;
        private PathConf pathConf;

        public ComboConf(Combo combo, PathConf pathConf, int max) {
            this.max = max;
            this.combo = combo;
            this.pathConf = pathConf;
        }

        public static ComboConf instance(Combo combo, PathConf pathConf, int max) {
            return new ComboConf(combo, pathConf, max);
        }

        public ComboConf withIp(String ip) {
            this.combo.ip = ip;
            return this;
        }

        public ComboConf withHost(String host) {
            this.combo.host = host;
            return this;
        }

        public ComboConf withContentType(String contenttype) {
            this.combo.contenttype = contenttype;
            return this;
        }

        public ComboConf withResponseStatus(ResponseStatusCheck check) {
            this.combo.responseStatusCheck = check;
            return this;
        }

        public PathConf exclude(String pattern) {
            return this.exclude(pattern, null);
        }

        public PathConf exclude(String pattern, String method) {
            this.combo.matcher = PathMatcher.instance((String)pattern, (int)this.max);
            this.combo.method = method;
            this.pathConf.excludes.add(this.combo);
            return this.pathConf;
        }

        public PathConf include(String pattern) {
            return this.include(pattern, null);
        }

        public PathConf include(String pattern, String method) {
            this.combo.matcher = PathMatcher.instance((String)pattern, (int)this.max);
            this.combo.method = method;
            this.pathConf.includes.add(this.combo);
            return this.pathConf;
        }
    }
}

