/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class InputStreamReplicator {
    private InputStream is;
    private byte[] cache = null;

    public InputStreamReplicator(InputStream is) {
        this.is = is;
    }

    public static InputStreamReplicator instance(InputStream is) {
        return new InputStreamReplicator(is);
    }

    public InputStream getInputStream() {
        if (this.is == null) {
            return null;
        }
        if (this.cache == null) {
            try {
                int num;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((num = this.is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, num);
                }
                buffer.flush();
                this.cache = buffer.toByteArray();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new ByteArrayInputStream(this.cache);
    }
}

