/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OutputStreamTee
extends OutputStream {
    private OutputStream os;
    private ByteArrayOutputStream bos;

    public OutputStreamTee(OutputStream os) {
        this.os = os;
        this.bos = new ByteArrayOutputStream();
    }

    public static OutputStreamTee instance(OutputStream os) {
        return new OutputStreamTee(os);
    }

    public static OutputStream nullOutputStream() {
        return OutputStream.nullOutputStream();
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        this.bos.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.bos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.bos.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
        this.bos.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.bos.close();
    }

    public byte[] toByteArray() {
        return this.bos.toByteArray();
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.bos.toByteArray());
    }
}

