/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.filter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import sk.antons.web.filter.util.OutputStreamTee;
import sk.antons.web.filter.util.SimpleServletOutputStream;
import sk.antons.web.filter.util.WriterTee;

public class ServletResponseWrapper
implements ServletResponse {
    private ServletResponse response;
    private OutputStreamTee ostee = null;
    private WriterTee wtee = null;

    public ServletResponseWrapper(ServletResponse response) {
        this.response = response;
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.ostee == null) {
            this.ostee = new OutputStreamTee((OutputStream)this.response.getOutputStream());
        }
        return new SimpleServletOutputStream(this.ostee);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.wtee == null) {
            this.wtee = new WriterTee(this.response.getWriter());
        }
        return new PrintWriter(this.wtee);
    }

    public InputStream getContentInputStream() {
        if (this.ostee != null) {
            return this.ostee.toInputStream();
        }
        if (this.wtee != null) {
            return this.wtee.toInputStream();
        }
        return null;
    }

    public void setCharacterEncoding(String string) {
        this.response.setCharacterEncoding(string);
    }

    public void setContentLength(int i) {
        this.response.setContentLength(i);
    }

    public void setContentType(String string) {
        this.response.setContentType(string);
    }

    public void setBufferSize(int i) {
        this.response.setBufferSize(i);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setContentLengthLong(long len) {
        this.response.setContentLengthLong(len);
    }
}

