/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.javaflacencoder.BlockEncodeRequest;
import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.FLACOutputStream;
import net.sourceforge.javaflacencoder.FLACStreamIdentifier;
import net.sourceforge.javaflacencoder.MetadataBlockHeader;
import net.sourceforge.javaflacencoder.MetadataBlockStreamInfo;
import net.sourceforge.javaflacencoder.StreamConfiguration;

public class FLACStreamController {
    public static int DEBUG_LEV = 0;
    volatile boolean flacStreamIsOpen = false;
    private final ReentrantLock streamLock = new ReentrantLock();
    private FLACOutputStream out = null;
    EncodedElement FLAC_id = FLACStreamIdentifier.getIdentifier();
    volatile long samplesInStream;
    volatile long nextFrameNumber = 0L;
    long streamHeaderPos = 0L;
    volatile int minFrameSize = Integer.MAX_VALUE;
    volatile int maxFrameSize = 0;
    volatile int minBlockSize = Integer.MAX_VALUE;
    volatile int maxBlockSize = 0;
    StreamConfiguration streamConfig = null;

    public FLACStreamController(FLACOutputStream fos, StreamConfiguration sc) {
        this.out = fos;
        this.streamConfig = new StreamConfiguration(sc);
        this.minFrameSize = Integer.MAX_VALUE;
        this.maxFrameSize = 0;
        this.minBlockSize = Integer.MAX_VALUE;
        this.maxBlockSize = 0;
        this.samplesInStream = 0L;
        this.streamHeaderPos = 0L;
        this.nextFrameNumber = 0L;
    }

    public void setFLACOutputStream(FLACOutputStream fos) {
        this.streamLock.lock();
        try {
            if (this.flacStreamIsOpen) {
                throw new IllegalStateException("Cannot set new output stream while flac stream is open");
            }
            this.out = fos;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    public FLACOutputStream getFLACOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFLACStream(byte[] md5Hash, StreamConfiguration streamConfig) throws IOException {
        this.streamLock.lock();
        try {
            if (!this.flacStreamIsOpen) {
                throw new IllegalStateException("Error. Cannot close a non-opened stream");
            }
            StreamConfiguration tempSC = new StreamConfiguration(streamConfig);
            tempSC.setMaxBlockSize(this.maxBlockSize);
            tempSC.setMinBlockSize(this.minBlockSize);
            EncodedElement streamInfo = MetadataBlockStreamInfo.getStreamInfo(tempSC, this.minFrameSize, this.maxFrameSize, this.samplesInStream, md5Hash);
            if (this.out.canSeek()) {
                this.out.seek(this.streamHeaderPos);
                this.writeDataToOutput(streamInfo);
            }
            this.flacStreamIsOpen = false;
            this.out.close();
        }
        finally {
            this.streamLock.unlock();
        }
    }

    private int writeDataToOutput(EncodedElement data) throws IOException {
        int writtenBytes = 0;
        int offset = 0;
        int currentByte = 0;
        byte unfullByte = 0;
        byte[] eleData = null;
        int usableBits = 0;
        int lastByte = 0;
        for (EncodedElement current = data; current != null; current = current.getNext()) {
            eleData = current.getData();
            usableBits = current.getUsableBits();
            currentByte = 0;
            if (offset != 0) {
                unfullByte = (byte)(unfullByte | eleData[currentByte++]);
                this.out.write(unfullByte);
            }
            if ((lastByte = usableBits / 8) > 0) {
                this.out.write(eleData, currentByte, lastByte - currentByte);
            }
            if ((offset = usableBits % 8) == 0) continue;
            unfullByte = eleData[lastByte];
        }
        if (offset != 0) {
            this.out.write(eleData, lastByte, 1);
        }
        return writtenBytes;
    }

    public long incrementFrameNumber() {
        return this.nextFrameNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFLACStream() throws IOException {
        this.streamLock.lock();
        try {
            this.reset();
            this.flacStreamIsOpen = true;
            this.out.write(this.FLAC_id.getData(), 0, this.FLAC_id.getUsableBits() / 8);
            byte[] md5Hash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            EncodedElement streamInfo = MetadataBlockStreamInfo.getStreamInfo(this.streamConfig, this.minFrameSize, this.maxFrameSize, this.samplesInStream, md5Hash);
            int size = streamInfo.getUsableBits() / 8;
            EncodedElement metadataBlockHeader = MetadataBlockHeader.getMetadataBlockHeader(false, MetadataBlockHeader.MetadataBlockType.STREAMINFO, size);
            this.writeDataToOutput(metadataBlockHeader);
            this.streamHeaderPos = this.out.getPos();
            this.out.write(streamInfo.getData(), 0, size);
            this.writePaddingToFoolJFlac();
        }
        finally {
            this.streamLock.unlock();
        }
    }

    private void reset() {
        this.minFrameSize = Integer.MAX_VALUE;
        this.maxFrameSize = 0;
        this.minBlockSize = Integer.MAX_VALUE;
        this.maxBlockSize = 0;
        this.samplesInStream = 0L;
        this.streamHeaderPos = 0L;
        this.nextFrameNumber = 0L;
    }

    private void writePaddingToFoolJFlac() throws IOException {
        int size = 40;
        byte[] padding = new byte[size];
        EncodedElement metadataBlockHeader = MetadataBlockHeader.getMetadataBlockHeader(true, MetadataBlockHeader.MetadataBlockType.PADDING, 40);
        this.writeDataToOutput(metadataBlockHeader);
        this.out.write(padding, 0, size);
    }

    public void writeBlock(BlockEncodeRequest ber) throws IOException {
        int frameSize;
        if (!this.flacStreamIsOpen) {
            throw new IllegalStateException("Cannot write on a non-opened stream");
        }
        this.writeDataToOutput(ber.result.getNext());
        if (ber.count != ber.encodedSamples) {
            System.err.println("Error encoding frame number: " + ber.frameNumber + ", FLAC stream potentially invalid");
        }
        this.samplesInStream += (long)ber.encodedSamples;
        if (ber.encodedSamples > this.maxBlockSize) {
            this.maxBlockSize = ber.encodedSamples;
        }
        if (ber.encodedSamples < this.minBlockSize) {
            this.minBlockSize = ber.encodedSamples;
        }
        if ((frameSize = ber.result.getTotalBits() / 8) > this.maxFrameSize) {
            this.maxFrameSize = frameSize;
        }
        if (frameSize < this.minFrameSize) {
            this.minFrameSize = frameSize;
        }
    }
}

