/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bbottema.javareflection.ExternalClassLoader;
import org.bbottema.javareflection.ValueConverter;

public final class JReflect {
    private static final Map<Class<?>, Map<String, Map<AccessibleObject, Class<?>[]>>> methodCache = new LinkedHashMap();
    private static final Map<String, Class<?>> classCache = new HashMap();
    private static final Map<Class<?>, Integer> numSizes = new LinkedHashMap();

    public static void resetCaches() {
        classCache.clear();
        methodCache.clear();
    }

    private JReflect() {
    }

    @Nullable
    public static Class<?> locateClass(String className, boolean fullscan, ExternalClassLoader classLoader) {
        return JReflect.locateClass(className, fullscan, classLoader, true);
    }

    @Nullable
    public static Class<?> locateClass(String className, boolean fullscan, ExternalClassLoader classLoader, boolean useCache) {
        String cacheKey = className + fullscan;
        if (useCache && classCache.containsKey(cacheKey)) {
            return classCache.get(className);
        }
        Class<?> _class = null;
        if (fullscan) {
            Package[] ps = Package.getPackages();
            for (int i = 0; i < ps.length && _class == null; ++i) {
                _class = JReflect.locateClass(ps[i].getName() + "." + className, classLoader);
            }
        } else {
            _class = JReflect.locateClass("java.lang." + className, classLoader);
        }
        if (useCache) {
            classCache.put(cacheKey, _class);
        }
        return _class;
    }

    @Nullable
    public static Class<?> locateClass(String fullClassName, ExternalClassLoader classLoader) {
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nonnull
    public static <T> T newInstanceSimple(Class<T> _class) {
        try {
            return _class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "we don't pass in arguments";
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
    }

    @Nullable
    public static <T> T invokeCompatibleMethod(Object context, Class<?> datatype, String identifier, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        Class<?>[] signature = JReflect.collectTypes(args);
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
            }
            catch (NoSuchMethodException e2) {
                lookupMode.add(LookupMode.COMMON_CONVERT);
                method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
            }
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(context, args);
        }
        catch (IllegalArgumentException e) {
            Object[] convertedArgs = ValueConverter.convert(args, method.getParameterTypes(), true);
            return (T)method.invoke(context, convertedArgs);
        }
    }

    @Nonnull
    public static <T> T invokeCompatibleConstructor(Class<T> datatype, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] signature = JReflect.collectTypes(args);
        return JReflect.invokeConstructor(datatype, signature, args);
    }

    @Nonnull
    public static <T> T invokeConstructor(Class<T> datatype, Class<?>[] signature, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor;
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
            }
            catch (NoSuchMethodException e2) {
                lookupMode.add(LookupMode.COMMON_CONVERT);
                constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
            }
        }
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            Object[] convertedArgs = ValueConverter.convert(args, constructor.getParameterTypes(), true);
            return constructor.newInstance(convertedArgs);
        }
    }

    @Nonnull
    public static Class<?>[] collectTypes(Object[] objects) {
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            types[i] = o != null ? o.getClass() : Object.class;
        }
        return types;
    }

    @Nonnull
    public static <T> Constructor<T> findCompatibleConstructor(Class<T> datatype, EnumSet<LookupMode> lookupMode, Class<?> ... types) throws NoSuchMethodException {
        Constructor<T> constructor = (Constructor<T>)JReflect.getMethodFromCache(datatype, datatype.getName(), types);
        if (constructor != null) {
            return constructor;
        }
        try {
            constructor = datatype.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> typeslist = JReflect.generateCompatibleSignatures(lookupMode, types);
            for (Class<?>[] aTypeslist : typeslist) {
                try {
                    constructor = datatype.getConstructor(aTypeslist);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (constructor != null) {
            JReflect.addMethodToCache(datatype, datatype.getName(), constructor, types);
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    @Nullable
    public static Method findSimpleCompatibleMethod(Class<?> datatype, String methodName, Class<?> ... signature) {
        try {
            return JReflect.findCompatibleMethod(datatype, methodName, EnumSet.noneOf(LookupMode.class), signature);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nonnull
    public static Method findCompatibleMethod(Class<?> datatype, String methodName, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        Method method = (Method)JReflect.getMethodFromCache(datatype, methodName, signature);
        if (method != null) {
            return method;
        }
        try {
            method = JReflect.getMethod(datatype, methodName, signature);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> signatures = JReflect.generateCompatibleSignatures(lookupMode, signature);
            for (Class<?>[] compatibleSignature : signatures) {
                try {
                    method = JReflect.getMethod(datatype, methodName, compatibleSignature);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (method != null) {
            JReflect.addMethodToCache(datatype, methodName, method, signature);
            return method;
        }
        throw new NoSuchMethodException();
    }

    @Nonnull
    public static Method getMethod(Class<?> datatype, String name, Class<?> ... signature) throws NoSuchMethodException {
        for (Class<?> iface : datatype.getInterfaces()) {
            try {
                return iface.getMethod(name, signature);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            return datatype.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            return datatype.getDeclaredMethod(name, signature);
        }
    }

    @Nonnull
    private static List<Class<?>[]> generateCompatibleSignatures(EnumSet<LookupMode> lookupMode, Class<?> ... signature) {
        ArrayList<Class<?>[]> signatures = new ArrayList<Class<?>[]>();
        JReflect.generateCompatibleSignatures(0, lookupMode, signatures, signature);
        return signatures;
    }

    private static void generateCompatibleSignatures(int index, EnumSet<LookupMode> lookupMode, List<Class<?>[]> signatures, Class<?> ... signature) {
        if (index == signature.length) {
            signatures.add(signature);
        } else {
            Class[] newSignature;
            Class<?>[] autoboxed;
            Class<?> original = signature[index];
            JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, (Class[])signature.clone());
            if (lookupMode.contains((Object)LookupMode.AUTOBOX) && (autoboxed = JReflect.autobox(original)) != null) {
                newSignature = (Class[])JReflect.replaceInArray((Object[])signature.clone(), index, autoboxed);
                JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature);
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_INTERFACE)) {
                for (Class<?> iface : original.getInterfaces()) {
                    Class<?>[] newSignature2 = JReflect.replaceInArray((Object[])signature.clone(), index, iface);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature2);
                }
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_SUPER)) {
                Class<?> supertype = original;
                while ((supertype = supertype.getSuperclass()) != null) {
                    newSignature = JReflect.replaceInArray((Object[])signature.clone(), index, supertype);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature);
                }
            }
            if (lookupMode.contains((Object)LookupMode.COMMON_CONVERT)) {
                for (Class<?> convert : ValueConverter.collectCompatibleTypes(original)) {
                    Class<?>[] newSignature3 = JReflect.replaceInArray((Object[])signature.clone(), index, convert);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature3);
                }
            }
        }
    }

    @Nullable
    public static Class<?> autobox(Class<?> c) {
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    @Nullable
    public static Field solveField(Object o, String fieldName) {
        try {
            if (o.getClass().equals(Class.class)) {
                return ((Class)o).getField(fieldName);
            }
            return o.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    private static <T> AccessibleObject getMethodFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        Map<AccessibleObject, Class<?>[]> signatures;
        Map<String, Map<AccessibleObject, Class<?>[]>> owner = methodCache.get(datatype);
        if (signature.length > 0 && owner != null && (signatures = owner.get(method)) != null) {
            for (Map.Entry<AccessibleObject, Class<?>[]> entry : signatures.entrySet()) {
                if (!Arrays.equals(entry.getValue(), signature)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private static void addMethodToCache(Class<?> datatype, String method, AccessibleObject methodRef, Class<?> ... signature) {
        if (signature.length > 0) {
            LinkedHashMap<String, Map> owner = methodCache.get(datatype);
            owner = owner != null ? owner : new LinkedHashMap<String, Map>();
            Map methods = (Map)owner.get(method);
            methods = methods != null ? methods : new LinkedHashMap();
            methods.put(methodRef, signature);
            methods.put(methodRef, signature);
            owner.put(method, methods);
            methodCache.put(datatype, owner);
        }
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = JReflect.solveField(o, property);
        if (field != null) {
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                assignedValue = ValueConverter.convert(value, field.getType());
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    public static boolean isPackage(String name) {
        return name.equals("java") || Package.getPackage(name) != null;
    }

    @Nonnull
    public static Class<?> widestNumberClass(Number ... numbers) {
        Integer widest = 0;
        Class widestNumberType = Byte.class;
        for (Number number : numbers) {
            Integer size = numSizes.get(number.getClass());
            if (size <= widest) continue;
            widestNumberType = number.getClass();
            widest = size;
        }
        return widestNumberType;
    }

    @Nonnull
    public static Collection<String> collectProperties(Object subject) {
        Field[] fields;
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        return properties;
    }

    @Nonnull
    public static Set<String> collectMethods(Object subject, boolean publicOnly) {
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>();
        HashSet<Method> allMethods = new HashSet<Method>(Arrays.asList(subject.getClass().getMethods()));
        if (!publicOnly) {
            for (Class<?> _class = subject.getClass(); _class != null; _class = _class.getSuperclass()) {
                allMethods.addAll(Arrays.asList(_class.getDeclaredMethods()));
            }
        }
        for (Method m : allMethods) {
            methodNames.add(m.getName());
        }
        return methodNames;
    }

    @Nonnull
    public static <T> T[] replaceInArray(T[] array, int index, T value) {
        array[index] = value;
        return array;
    }

    static {
        int size = 0;
        numSizes.put(Byte.class, ++size);
        numSizes.put(Short.class, ++size);
        numSizes.put(Integer.class, ++size);
        numSizes.put(Long.class, ++size);
        numSizes.put(Float.class, ++size);
        numSizes.put(Double.class, ++size);
    }

    public static enum LookupMode {
        AUTOBOX,
        CAST_TO_SUPER,
        CAST_TO_INTERFACE,
        COMMON_CONVERT;

    }
}

