/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import lombok.NonNull;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.util.commonslang25.NumberUtils;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Nullable
public final class StringConverters {
    public static final Collection<ValueFunction<String, ?>> STRING_CONVERTERS = StringConverters.produceStringConverters();

    private static Collection<ValueFunction<String, ?>> produceStringConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new ValueFunction.ValueFunctionImpl<String, String>(String.class, String.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Character>(String.class, Character.class, new StringToCharacterFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Boolean>(String.class, Boolean.class, new StringToBooleanFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Number>(String.class, Number.class, new StringToNumberFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Byte>(String.class, Byte.class, new StringToByteFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Short>(String.class, Short.class, new StringToShortFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Long>(String.class, Long.class, new StringToLongFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Float>(String.class, Float.class, new StringToFloatFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Double>(String.class, Double.class, new StringToDoubleFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, BigInteger>(String.class, BigInteger.class, new StringToBigIntegerFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, BigDecimal>(String.class, BigDecimal.class, new StringToBigDecimalFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, File>(String.class, File.class, new StringToFileFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, UUID>(String.class, UUID.class, new StringToUUIDFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Date>(String.class, Date.class, new StringToDateFunction()));
        ArrayList arrayList = converters;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters.produceStringConverters must not return null");
        }
        return arrayList;
    }

    public static <T extends Enum<T>> ValueFunction<String, T> produceStringToEnumConverter(Class<T> targetEnumClass) {
        if (targetEnumClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters.produceStringToEnumConverter must not be null");
        }
        ValueFunction.ValueFunctionImpl<String, T> valueFunctionImpl = new ValueFunction.ValueFunctionImpl<String, T>(String.class, targetEnumClass, new StringToEnumFunction<T>(targetEnumClass));
        if (valueFunctionImpl == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters.produceStringToEnumConverter must not return null");
        }
        return valueFunctionImpl;
    }

    public static <F> ValueFunction<F, String> produceTypeToStringConverter(Class<F> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters.produceTypeToStringConverter must not be null");
        }
        ValueFunction.ValueFunctionImpl<F, String> valueFunctionImpl = new ValueFunction.ValueFunctionImpl<F, String>(fromType, String.class, Function.Functions.simpleToString());
        if (valueFunctionImpl == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters.produceTypeToStringConverter must not return null");
        }
        return valueFunctionImpl;
    }

    private StringConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class StringToDateFunction
    implements Function<String, Date> {
        private static ThreadLocal<DateFormat> DATETIME_FORMAT_SIMPLE = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                if (simpleDateFormat == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDateFunction$1.initialValue must not return null");
                }
                return simpleDateFormat;
            }
        };
        private static ThreadLocal<DateFormat> DATETIME_FORMAT_ISO8601 = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                if (simpleDateFormat == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDateFunction$2.initialValue must not return null");
                }
                return simpleDateFormat;
            }
        };
        private IllegalArgumentException INCOMPATIBLE_EXCEPTION = new IllegalArgumentException("not compatible with yyyy-MM-dd or yyyy-MM-dd HH:mm");

        StringToDateFunction() {
        }

        @Override
        public Date apply(String value) {
            Date date;
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDateFunction.apply must not be null");
            }
            try {
                date = DATETIME_FORMAT_ISO8601.get().parse(value);
            }
            catch (IllegalArgumentException | ParseException e1) {
                Date date2;
                try {
                    date2 = DATETIME_FORMAT_SIMPLE.get().parse(value);
                }
                catch (IllegalArgumentException | ParseException e2) {
                    throw new IncompatibleTypeException((Object)value, String.class, Date.class, this.INCOMPATIBLE_EXCEPTION);
                }
                if (date2 == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDateFunction.apply must not return null");
                }
                return date2;
            }
            if (date == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDateFunction.apply must not return null");
            }
            return date;
        }
    }

    private static class StringToUUIDFunction
    implements Function<String, UUID> {
        private StringToUUIDFunction() {
        }

        @Override
        public UUID apply(String value) {
            UUID uUID;
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToUUIDFunction.apply must not be null");
            }
            try {
                uUID = UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                throw new IncompatibleTypeException(value, String.class, UUID.class);
            }
            if (uUID == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToUUIDFunction.apply must not return null");
            }
            return uUID;
        }
    }

    private static class StringToFileFunction
    implements Function<String, File> {
        private static final Logger LOGGER = LoggerFactory.getLogger(StringToBigDecimalFunction.class);

        private StringToFileFunction() {
        }

        @Override
        public File apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToFileFunction.apply must not be null");
            }
            File file = new File(value);
            if (!file.exists()) {
                LOGGER.debug("file not found for [" + value + "]");
                throw new IncompatibleTypeException(value, String.class, File.class);
            }
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToFileFunction.apply must not return null");
            }
            return file2;
        }
    }

    private static class StringToBigDecimalFunction
    implements Function<String, BigDecimal> {
        private StringToBigDecimalFunction() {
        }

        @Override
        public BigDecimal apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBigDecimalFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                BigDecimal bigDecimal = new BigDecimal(value);
                if (bigDecimal == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBigDecimalFunction.apply must not return null");
                }
                return bigDecimal;
            }
            throw new IncompatibleTypeException(value, String.class, BigDecimal.class);
        }
    }

    private static class StringToBigIntegerFunction
    implements Function<String, BigInteger> {
        private StringToBigIntegerFunction() {
        }

        @Override
        public BigInteger apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBigIntegerFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                BigInteger bigInteger = BigInteger.valueOf(Long.parseLong(value));
                if (bigInteger == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBigIntegerFunction.apply must not return null");
                }
                return bigInteger;
            }
            throw new IncompatibleTypeException(value, String.class, BigInteger.class);
        }
    }

    private static class StringToDoubleFunction
    implements Function<String, Double> {
        private StringToDoubleFunction() {
        }

        @Override
        public Double apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDoubleFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                Double d = Double.parseDouble(value);
                if (d == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToDoubleFunction.apply must not return null");
                }
                return d;
            }
            throw new IncompatibleTypeException(value, String.class, Double.class);
        }
    }

    private static class StringToFloatFunction
    implements Function<String, Float> {
        private StringToFloatFunction() {
        }

        @Override
        public Float apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToFloatFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                Float f = Float.valueOf(Float.parseFloat(value));
                if (f == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToFloatFunction.apply must not return null");
                }
                return f;
            }
            throw new IncompatibleTypeException(value, String.class, Float.class);
        }
    }

    private static class StringToLongFunction
    implements Function<String, Long> {
        private StringToLongFunction() {
        }

        @Override
        public Long apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToLongFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                Long l = Long.parseLong(value);
                if (l == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToLongFunction.apply must not return null");
                }
                return l;
            }
            throw new IncompatibleTypeException(value, String.class, Long.class);
        }
    }

    private static class StringToShortFunction
    implements Function<String, Short> {
        private StringToShortFunction() {
        }

        @Override
        public Short apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToShortFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                Short s;
                try {
                    s = Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Object)value, String.class, Short.class, e);
                }
                if (s == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToShortFunction.apply must not return null");
                }
                return s;
            }
            throw new IncompatibleTypeException(value, String.class, Short.class);
        }
    }

    private static class StringToByteFunction
    implements Function<String, Byte> {
        private StringToByteFunction() {
        }

        @Override
        public Byte apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToByteFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                Byte by;
                try {
                    by = Byte.parseByte(value);
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Object)value, String.class, Byte.class, e);
                }
                if (by == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToByteFunction.apply must not return null");
                }
                return by;
            }
            throw new IncompatibleTypeException(value, String.class, Byte.class);
        }
    }

    private static class StringToNumberFunction
    implements Function<String, Number> {
        private StringToNumberFunction() {
        }

        @Override
        public Number apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToNumberFunction.apply must not be null");
            }
            if (NumberUtils.isNumber(value)) {
                BigDecimal bigDecimal = new BigDecimal(value);
                if (bigDecimal == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToNumberFunction.apply must not return null");
                }
                return bigDecimal;
            }
            throw new IncompatibleTypeException(value, String.class, Number.class);
        }
    }

    private static class StringToBooleanFunction
    implements Function<String, Boolean> {
        private StringToBooleanFunction() {
        }

        @Override
        public Boolean apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBooleanFunction.apply must not be null");
            }
            if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0")) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBooleanFunction.apply must not return null");
                }
                return bl;
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1")) {
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToBooleanFunction.apply must not return null");
                }
                return bl;
            }
            throw new IncompatibleTypeException(value, String.class, Boolean.class);
        }
    }

    private static class StringToCharacterFunction
    implements Function<String, Character> {
        private StringToCharacterFunction() {
        }

        @Override
        public Character apply(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToCharacterFunction.apply must not be null");
            }
            if (value.length() == 1) {
                Character c = Character.valueOf(value.charAt(0));
                if (c == null) {
                    throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToCharacterFunction.apply must not return null");
                }
                return c;
            }
            throw new IncompatibleTypeException(value, String.class, Character.class);
        }
    }

    private static class StringToEnumFunction<T extends Enum<T>>
    implements Function<String, T> {
        @NonNull
        private final Class<T> targetEnumClass;

        @Override
        public T apply(String value) {
            T t;
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToEnumFunction.apply must not be null");
            }
            try {
                t = Enum.valueOf(this.targetEnumClass, value);
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new IncompatibleTypeException((Object)value, String.class, this.targetEnumClass, e);
            }
            if (t == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToEnumFunction.apply must not return null");
            }
            return t;
        }

        public StringToEnumFunction(@NonNull Class<T> targetEnumClass) {
            if (targetEnumClass == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/StringConverters$StringToEnumFunction.<init> must not be null");
            }
            if (targetEnumClass == null) {
                throw new NullPointerException("targetEnumClass is marked @NonNull but is null");
            }
            this.targetEnumClass = targetEnumClass;
        }
    }
}

