/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static String INVALID_GENERIC_TYPE_DEFINITION = "Unable to determine generic type, probably due to type erasure. Make sure the type is part of a class signature (it can not be a field or variable, or a nested generic type such as List<NestedType>)";

    public static <T> Class<T> findParameterType(Class<?> instanceClass, Class<?> classOfInterest, int parameterIndex) {
        Class clazz;
        if (instanceClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ReflectionUtils.findParameterType must not be null");
        }
        if (classOfInterest == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ReflectionUtils.findParameterType must not be null");
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (classOfInterest != instanceClass.getSuperclass()) {
            ReflectionUtils.extractTypeArguments(typeMap, instanceClass);
            if ((instanceClass = instanceClass.getSuperclass()) != null) continue;
            throw new IllegalArgumentException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)instanceClass.getGenericSuperclass();
        Type actualType = parameterizedType.getActualTypeArguments()[parameterIndex];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            Class clazz2 = (Class)actualType;
            if (clazz2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/ReflectionUtils.findParameterType must not return null");
            }
            return clazz2;
        }
        try {
            clazz = (Class)((ParameterizedType)actualType).getRawType();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(INVALID_GENERIC_TYPE_DEFINITION, e);
        }
        if (clazz == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ReflectionUtils.findParameterType must not return null");
        }
        return clazz;
    }

    private static void extractTypeArguments(Map<Type, Type> typeMap, Class<?> clazz) {
        if (typeMap == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ReflectionUtils.extractTypeArguments must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ReflectionUtils.extractTypeArguments must not be null");
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        TypeVariable<Class<T>>[] typeParameter = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] actualTypeArgument = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeParameter.length; ++i) {
            if (typeMap.containsKey(actualTypeArgument[i])) {
                actualTypeArgument[i] = typeMap.get(actualTypeArgument[i]);
            }
            typeMap.put(typeParameter[i], actualTypeArgument[i]);
        }
    }
}

