/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bbottema.javareflection.util.graph.Node;
import org.bbottema.javareflection.util.graph.NodePathComparator;
import org.jetbrains.annotations.NotNull;

public final class GraphHelper {
    public static <T> boolean isPathPossible(Node<T> startingPoint, Node<T> destination) {
        return GraphHelper.findPossiblePaths(startingPoint, destination, new ArrayDeque<Node<T>>(), new ArrayList<List<Node<T>>>(), true, 4);
    }

    public static <T> List<List<Node<T>>> findAllPathsAscending(Node<T> startingPoint, Node<T> destination) {
        ArrayList<List<Node<T>>> allPaths = new ArrayList<List<Node<T>>>();
        GraphHelper.findPossiblePaths(startingPoint, destination, new ArrayDeque<Node<T>>(), allPaths, false, 4);
        Collections.sort(allPaths, NodePathComparator.INSTANCE());
        GraphHelper.removeStartingPoints(allPaths);
        return allPaths;
    }

    private static <T> void removeStartingPoints(List<List<Node<T>>> allPaths) {
        for (List<Node<T>> path : allPaths) {
            path.remove(0);
        }
    }

    private static <T> boolean findPossiblePaths(Node<T> currentNode, Node<T> destination, Deque<Node<T>> currentPath, List<List<Node<T>>> possiblePathsSoFar, boolean returnOnFirstPathFound, int cutOffEdgeCount) {
        boolean foundAPath = false;
        if (!currentPath.contains(currentNode)) {
            currentPath.addLast(currentNode);
            if (currentNode.equals(destination)) {
                possiblePathsSoFar.add(new ArrayList<Node<T>>(currentPath));
                foundAPath = true;
            } else if (currentPath.size() <= cutOffEdgeCount) {
                Node<T> nextNode;
                Iterator<Node<T>> iterator = currentNode.getToNodes().keySet().iterator();
                while (!(!iterator.hasNext() || (foundAPath |= GraphHelper.findPossiblePaths(nextNode = iterator.next(), destination, currentPath, possiblePathsSoFar, returnOnFirstPathFound, cutOffEdgeCount)) && returnOnFirstPathFound)) {
                }
            }
            currentPath.removeLast();
        }
        return foundAPath;
    }

    @NotNull
    public static <T> Set<Node<T>> findReachableNodes(Node<T> fromNode) {
        HashSet<Node<T>> reachableNodes = new HashSet<Node<T>>();
        GraphHelper.findReachableNodes(fromNode, reachableNodes);
        reachableNodes.remove(fromNode);
        return reachableNodes;
    }

    private static <T> void findReachableNodes(Node<T> currentNode, Set<Node<T>> reachableNodesSoFar) {
        for (Node<T> reachableNode : currentNode.getToNodes().keySet()) {
            if (!reachableNodesSoFar.add(reachableNode)) continue;
            GraphHelper.findReachableNodes(reachableNode, reachableNodesSoFar);
        }
    }

    private GraphHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

