/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.PackageUtils;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    @Nullable
    public static <T> Class<T> locateClass(String className, boolean fullscan, @Nullable ClassLoader classLoader) {
        Class<T> _class;
        String cacheKey = className + fullscan;
        if (LookupCaches.CLASS_CACHE.containsKey(cacheKey)) {
            return LookupCaches.CLASS_CACHE.get(cacheKey);
        }
        if (fullscan) {
            _class = ClassUtils.locateClass(className, null, classLoader);
        } else {
            _class = ClassUtils.locateClass(className, "java.lang", classLoader);
            if (_class == null) {
                _class = ClassUtils.locateClass(className, "java.util", classLoader);
            }
            if (_class == null) {
                _class = ClassUtils.locateClass(className, "java.math", classLoader);
            }
        }
        LookupCaches.CLASS_CACHE.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static <T> Class<T> locateClass(String className, @Nullable String inPackage, @Nullable ClassLoader classLoader) {
        String cacheKey = className + inPackage;
        if (LookupCaches.CLASS_CACHE.containsKey(cacheKey)) {
            return LookupCaches.CLASS_CACHE.get(cacheKey);
        }
        Class<Object> _class = ClassUtils.locateClass(className, classLoader);
        if (_class == null) {
            _class = PackageUtils.scanPackagesForClass(className, inPackage, classLoader);
        }
        LookupCaches.CLASS_CACHE.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static <T> Class<T> locateClass(String fullClassName, @Nullable ClassLoader classLoader) {
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T newInstanceSimple(Class<T> _class) {
        try {
            return ConstructorFactory.obtainConstructor(_class).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
    }

    @Nullable
    public static <T> T solveFieldValue(Object object, String fieldName) {
        Field field = ClassUtils.solveField(object, fieldName);
        if (field == null) {
            throw new RuntimeException(new NoSuchFieldException());
        }
        field.setAccessible(true);
        try {
            return MiscUtil.trustedNullableCast(field.get(object));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Was unable to retrieve value from field %s", e);
        }
    }

    @Nullable
    public static Field solveField(Object object, String fieldName) {
        return object.getClass().equals(Class.class) ? ClassUtils.solveField((Class)object, fieldName) : ClassUtils.solveField(object.getClass(), fieldName);
    }

    @Nullable
    public static Field solveField(Class<?> _class, String fieldName) {
        Field resolvedField = null;
        try {
            resolvedField = _class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            for (int i = 0; resolvedField == null && i < _class.getInterfaces().length; ++i) {
                resolvedField = ClassUtils.solveField(_class.getInterfaces()[i], fieldName);
            }
            for (Class<?> superclass = _class.getSuperclass(); resolvedField == null && superclass != null; superclass = superclass.getSuperclass()) {
                resolvedField = ClassUtils.solveField(superclass, fieldName);
            }
        }
        return resolvedField;
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = ClassUtils.solveField(o, property);
        if (field != null) {
            field.setAccessible(true);
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                try {
                    assignedValue = ValueConversionHelper.convert(value, field.getType());
                }
                catch (IncompatibleTypeException e) {
                    throw new NoSuchFieldException(e.getMessage());
                }
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    @NotNull
    public static Collection<String> collectPropertyNames(Object subject) {
        Field[] fields;
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        return properties;
    }

    public static Set<String> collectMethodNames(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        HashSet<String> methodNames = new HashSet<String>();
        for (Method m : ClassUtils.collectMethods(dataType, boundaryMarker, methodModifiers)) {
            methodNames.add(m.getName());
        }
        return methodNames;
    }

    public static List<Method> collectMethodsByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        LinkedHashMap<String, List<Method>> methodsByName = ClassUtils.collectMethodsMappingToName(type, boundaryMarker, methodModifiers);
        return methodsByName.containsKey(methodName) ? methodsByName.get(methodName) : new ArrayList();
    }

    public static boolean hasMethodByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        LinkedHashMap<String, List<Method>> methodsByName = ClassUtils.collectMethodsMappingToName(type, boundaryMarker, methodModifiers);
        return methodsByName.containsKey(methodName) && !methodsByName.get(methodName).isEmpty();
    }

    @Nullable
    public static Method findFirstMethodByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        List<Method> methods = ClassUtils.collectMethodsByName(type, boundaryMarker, methodModifiers, methodName);
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    public static LinkedHashMap<String, List<Method>> collectMethodsMappingToName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        LinkedHashMap<String, List<Method>> methodsMappedToName = new LinkedHashMap<String, List<Method>>();
        for (Method method : ClassUtils.collectMethods(type, boundaryMarker, methodModifiers)) {
            if (!methodsMappedToName.containsKey(method.getName())) {
                methodsMappedToName.put(method.getName(), new ArrayList());
            }
            methodsMappedToName.get(method.getName()).add(method);
        }
        return methodsMappedToName;
    }

    public static List<Method> collectMethods(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Method method : dataType.getDeclaredMethods()) {
            if (!MethodModifier.meetsModifierRequirements(method, methodModifiers)) continue;
            allMethods.add(method);
        }
        for (GenericDeclaration genericDeclaration : dataType.getInterfaces()) {
            allMethods.addAll(ClassUtils.collectMethods(genericDeclaration, boundaryMarker, methodModifiers));
        }
        if (dataType != boundaryMarker && dataType.getSuperclass() != null) {
            allMethods.addAll(ClassUtils.collectMethods(dataType.getSuperclass(), boundaryMarker, methodModifiers));
        }
        return allMethods;
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class ConstructorFactory {
        ConstructorFactory() {
        }

        static <T> Constructor<T> obtainConstructor(Class<T> _class) throws NoSuchMethodException {
            return _class.getConstructor(new Class[0]);
        }
    }
}

