/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.util.ArrayList;
import java.util.Collection;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.valueconverter.ValueFunction;

public final class BooleanConverters {
    public static final Collection<ValueFunction<Boolean, ?>> BOOLEAN_CONVERTERS = BooleanConverters.produceBooleanConverters();

    private static Collection<ValueFunction<Boolean, ?>> produceBooleanConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, Boolean>(Boolean.TYPE, Boolean.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, Boolean>(Boolean.class, Boolean.TYPE, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, Boolean>(Boolean.TYPE, Boolean.TYPE, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, Boolean>(Boolean.class, Boolean.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, String>(Boolean.class, String.class, Function.Functions.simpleToString()));
        converters.add(new ValueFunction.ValueFunctionImpl<Boolean, Number>(Boolean.class, Number.class, new BooleanToNumberFunction()));
        return converters;
    }

    private BooleanConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class BooleanToNumberFunction
    implements Function<Boolean, Number> {
        private BooleanToNumberFunction() {
        }

        @Override
        public Number apply(Boolean value) {
            return value != false ? 1 : 0;
        }
    }
}

