/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter;

import lombok.NonNull;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;

public interface ValueFunction<F, T> {
    @NonNull
    public Class<F> getFromType();

    @NonNull
    public Class<T> getTargetType();

    @NonNull
    public T convertValue(@NonNull F var1) throws IncompatibleTypeException;

    public static class ValueFunctionImpl<F, T>
    implements ValueFunction<F, T> {
        @NonNull
        protected final Class<F> fromType;
        @NonNull
        protected final Class<T> targetType;
        @NonNull
        private final Function<F, T> converter;

        @Override
        @NonNull
        public final T convertValue(@NonNull F value) throws IncompatibleTypeException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.converter.apply(value);
        }

        @Override
        @NonNull
        public Class<F> getFromType() {
            return this.fromType;
        }

        @Override
        @NonNull
        public Class<T> getTargetType() {
            return this.targetType;
        }

        @NonNull
        public Function<F, T> getConverter() {
            return this.converter;
        }

        public ValueFunctionImpl(@NonNull Class<F> fromType, @NonNull Class<T> targetType, @NonNull Function<F, T> converter) {
            if (fromType == null) {
                throw new NullPointerException("fromType is marked non-null but is null");
            }
            if (targetType == null) {
                throw new NullPointerException("targetType is marked non-null but is null");
            }
            if (converter == null) {
                throw new NullPointerException("converter is marked non-null but is null");
            }
            this.fromType = fromType;
            this.targetType = targetType;
            this.converter = converter;
        }

        public String toString() {
            return "ValueFunction.ValueFunctionImpl(fromType=" + this.getFromType() + ", targetType=" + this.getTargetType() + ")";
        }
    }
}

