/*
 * Copyright (C) 2019 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bbottema.javasocksproxyserver.junit;

import org.bbottema.javasocksproxyserver.SocksServer;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.ExternalResource;

import javax.net.ServerSocketFactory;

/**
 * Creates a {@link SocksServer} once, and starts and stops it before and after each test.
 * <p>
 * Can be used both by JUnit's {@code Rule} and {@code ClassRule} (`the latter being the preferred usage).
 */
public class SockServerRule extends ExternalResource {

	private final SocksServer socksServer;
	private final int port;
	private final ServerSocketFactory serverSocketFactory;
	
	public SockServerRule(@NotNull Integer port) {
		this(port, ServerSocketFactory.getDefault());
	}
	
	public SockServerRule(@NotNull Integer port, @NotNull ServerSocketFactory serverSocketFactory) {
		this.socksServer = new SocksServer();
		this.port = port;
		this.serverSocketFactory = serverSocketFactory;
	}

	@Override
	protected void before() {
		this.socksServer.start(port, serverSocketFactory);
	}

	@Override
	protected void after() {
		this.socksServer.stop();
	}
}