/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    @Nullable
    public static InetAddress calcInetAddress(byte[] addr) {
        InetAddress IA;
        if (addr == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.calcInetAddress must not be null");
        }
        StringBuilder sIA = new StringBuilder();
        if (addr.length < 4) {
            LOGGER.error("calcInetAddress() - Invalid length of IP v4 - " + addr.length + " bytes");
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            sIA.append(Utils.byte2int(addr[i]));
            if (i >= 3) continue;
            sIA.append(".");
        }
        try {
            IA = InetAddress.getByName(sIA.toString());
        }
        catch (UnknownHostException e) {
            return null;
        }
        return IA;
    }

    public static int byte2int(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public static int calcPort(byte Hi, byte Lo) {
        return Utils.byte2int(Hi) << 8 | Utils.byte2int(Lo);
    }

    @NotNull
    public static String iP2Str(InetAddress IP) {
        if (IP == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.iP2Str must not be null");
        }
        String string = IP == null ? "NA/NA" : String.format("%s/%s", IP.getHostName(), IP.getHostAddress());
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.iP2Str must not return null");
        }
        return string;
    }

    @NotNull
    public static String getSocketInfo(Socket sock) {
        if (sock == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not be null");
        }
        String string = sock == null ? "<NA/NA:0>" : String.format("<%s:%d>", Utils.iP2Str(sock.getInetAddress()), sock.getPort());
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not return null");
        }
        return string;
    }

    @NotNull
    public static String getSocketInfo(DatagramPacket DGP) {
        if (DGP == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not be null");
        }
        String string = DGP == null ? "<NA/NA:0>" : String.format("<%s:%d>", Utils.iP2Str(DGP.getAddress()), DGP.getPort());
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not return null");
        }
        return string;
    }
}

