/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver.junit;

import javax.net.ServerSocketFactory;
import org.bbottema.javasocksproxyserver.SocksServer;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.ExternalResource;

public class SockServerRule
extends ExternalResource {
    private final SocksServer socksServer;
    private final int port;
    private final ServerSocketFactory serverSocketFactory;

    public SockServerRule(@NotNull Integer port) {
        if (port == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/junit/SockServerRule.<init> must not be null");
        }
        this(port, ServerSocketFactory.getDefault());
    }

    public SockServerRule(@NotNull Integer port, @NotNull ServerSocketFactory serverSocketFactory) {
        if (port == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/junit/SockServerRule.<init> must not be null");
        }
        if (serverSocketFactory == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javasocksproxyserver/junit/SockServerRule.<init> must not be null");
        }
        this.socksServer = new SocksServer();
        this.port = port;
        this.serverSocketFactory = serverSocketFactory;
    }

    protected void before() {
        this.socksServer.start(this.port, this.serverSocketFactory);
    }

    protected void after() {
        this.socksServer.stop();
    }
}

