/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import org.bbottema.javasocksproxyserver.ProxyHandler;
import org.bbottema.javasocksproxyserver.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSocksServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSocksServer.class);
    private static final long DEFAULT_SERVER_SOCKET_OPEN_TIMEOUT_MILLIS = 5000L;
    private static final long DEFAULT_SERVER_SOCKET_OPEN_RETRY_INTERVAL_MILLIS = 200L;
    private static final long DEFAULT_CLOSE_CONNECTION_TIMEOUT_MILLIS = 5000L;
    private final long serverSocketOpenTimeoutMillis;
    private final long serverSocketOpenRetryIntervalMillis;
    private final long closeConnectionTimeoutMillis;
    protected volatile boolean stopping = false;
    protected final Map<Integer, Thread> servers = new HashMap<Integer, Thread>();

    public SyncSocksServer() {
        this(5000L, 200L, 5000L);
    }

    public SyncSocksServer(long serverSocketOpenTimeoutMillis, long serverSocketOpenRetryIntervalMillis, long closeConnectionTimeoutMillis) {
        this.serverSocketOpenTimeoutMillis = serverSocketOpenTimeoutMillis;
        this.serverSocketOpenRetryIntervalMillis = serverSocketOpenRetryIntervalMillis;
        this.closeConnectionTimeoutMillis = closeConnectionTimeoutMillis;
    }

    public synchronized void start(int listenPort) {
        this.start(listenPort, ServerSocketFactory.getDefault());
    }

    public synchronized void start(int listenPort, ServerSocketFactory serverSocketFactory) {
        this.stopping = false;
        if (this.servers.containsKey(listenPort)) {
            LOGGER.error("SOCKS server already started on port {}", (Object)listenPort);
            return;
        }
        ServerProcess serverProcess = new ServerProcess(listenPort, serverSocketFactory);
        Thread thread = new Thread(serverProcess);
        this.servers.put(listenPort, thread);
        thread.start();
        if (!serverProcess.waitServerSocketOpened(this.serverSocketOpenTimeoutMillis)) {
            throw new RuntimeException("Timeout waiting socket to be opened");
        }
    }

    public synchronized void stop() {
        this.stopping = true;
        this.waitAllServersToJoin();
    }

    private void waitAllServersToJoin() {
        this.servers.forEach((port, thread) -> {
            LOGGER.debug("Waiting server on port {} to close", port);
            try {
                thread.join(this.closeConnectionTimeoutMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (thread.isAlive()) {
                LOGGER.error("Can't stop server on port {} to close", port);
            }
        });
        this.servers.clear();
    }

    static final class ProxyClient {
        private final Socket socket;
        private final ProxyHandler handler;
        private final Thread thread;

        private ProxyClient(Socket socket, ProxyHandler handler, Thread thread) {
            this.socket = socket;
            this.handler = handler;
            this.thread = thread;
        }

        public static ProxyClient of(Socket socket, ProxyHandler handler, Thread thread) {
            return new ProxyClient(socket, handler, thread);
        }

        public Socket getSocket() {
            return this.socket;
        }

        public ProxyHandler getHandler() {
            return this.handler;
        }

        public Thread getThread() {
            return this.thread;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyClient)) {
                return false;
            }
            ProxyClient other = (ProxyClient)o;
            Socket this$socket = this.getSocket();
            Socket other$socket = other.getSocket();
            if (this$socket == null ? other$socket != null : !this$socket.equals(other$socket)) {
                return false;
            }
            ProxyHandler this$handler = this.getHandler();
            ProxyHandler other$handler = other.getHandler();
            if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
                return false;
            }
            Thread this$thread = this.getThread();
            Thread other$thread = other.getThread();
            return !(this$thread == null ? other$thread != null : !this$thread.equals(other$thread));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Socket $socket = this.getSocket();
            result = result * 59 + ($socket == null ? 43 : $socket.hashCode());
            ProxyHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            Thread $thread = this.getThread();
            result = result * 59 + ($thread == null ? 43 : $thread.hashCode());
            return result;
        }

        public String toString() {
            return "SyncSocksServer.ProxyClient(socket=" + this.getSocket() + ", handler=" + this.getHandler() + ", thread=" + this.getThread() + ")";
        }
    }

    private class ServerProcess
    implements Runnable {
        protected final int port;
        private final ServerSocketFactory serverSocketFactory;
        private final List<ProxyClient> clients = new ArrayList<ProxyClient>();
        private final CountDownLatch serverSocketOpenLatch = new CountDownLatch(1);

        public ServerProcess(int port, ServerSocketFactory serverSocketFactory) {
            this.port = port;
            this.serverSocketFactory = serverSocketFactory;
        }

        @Override
        public void run() {
            LOGGER.debug("SOCKS server started...");
            try {
                this.handleClients(this.port);
                LOGGER.debug("SOCKS server stopped...");
            }
            catch (IOException | InterruptedException e) {
                LOGGER.debug("SOCKS server crashed...");
                Thread.currentThread().interrupt();
            }
            finally {
                this.waitAllClientsToJoinOrTimeout();
            }
        }

        protected void handleClients(int port) throws IOException, InterruptedException {
            while (!SyncSocksServer.this.stopping) {
                try (ServerSocket listenSocket = this.serverSocketFactory.createServerSocket(port);){
                    listenSocket.setSoTimeout(200);
                    LOGGER.debug("SOCKS server listening at port: " + listenSocket.getLocalPort());
                    this.serverSocketOpenLatch.countDown();
                    while (!SyncSocksServer.this.stopping) {
                        this.handleNextClient(listenSocket);
                        this.removeDisconnectedClients();
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Can't handle clients on port {} ", (Object)port, (Object)e);
                }
                if (SyncSocksServer.this.stopping) continue;
                Thread.sleep(SyncSocksServer.this.serverSocketOpenRetryIntervalMillis);
            }
        }

        private boolean waitServerSocketOpened(long timeoutMillis) {
            try {
                return this.serverSocketOpenLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Timeout while waiting for server socket to opened {}", (Object)this.port);
                throw new RuntimeException(e);
            }
        }

        private void handleNextClient(ServerSocket listenSocket) {
            try {
                Socket clientSocket = listenSocket.accept();
                clientSocket.setSoTimeout(200);
                LOGGER.debug("Connection from : " + Utils.getSocketInfo(clientSocket));
                ProxyHandler handler = new ProxyHandler(clientSocket);
                Thread thread = new Thread(handler);
                this.clients.add(ProxyClient.of(clientSocket, handler, thread));
                thread.start();
            }
            catch (InterruptedIOException clientSocket) {
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }

        private void waitAllClientsToJoinOrTimeout() {
            for (ProxyClient client : this.clients) {
                LOGGER.debug("Waiting client connection {} to close", (Object)Utils.getSocketInfo(client.socket));
                client.handler.close();
                try {
                    client.thread.join(SyncSocksServer.this.closeConnectionTimeoutMillis);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!client.thread.isAlive()) continue;
                LOGGER.error("Can't stop client connection {} to close", (Object)Utils.getSocketInfo(client.socket));
            }
            this.clients.clear();
        }

        private void removeDisconnectedClients() {
            this.clients.removeIf(client -> !((ProxyClient)client).thread.isAlive());
        }
    }
}

