/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.bbottema.javasocksproxyserver.Socks4Impl;
import org.bbottema.javasocksproxyserver.Socks5Impl;
import org.bbottema.javasocksproxyserver.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHandler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHandler.class);
    private InputStream m_ClientInput = null;
    private OutputStream m_ClientOutput = null;
    private InputStream m_ServerInput = null;
    private OutputStream m_ServerOutput = null;
    private Object m_lock;
    private Socks4Impl comm = null;
    Socket m_ClientSocket;
    Socket m_ServerSocket = null;
    byte[] m_Buffer = new byte[4096];

    public ProxyHandler(Socket clientSocket) {
        this.m_lock = this;
        this.m_ClientSocket = clientSocket;
        try {
            this.m_ClientSocket.setSoTimeout(10);
        }
        catch (SocketException e) {
            LOGGER.error("Socket Exception during seting Timeout.");
        }
        LOGGER.debug("Proxy Created.");
    }

    public void setLock(Object lock) {
        this.m_lock = lock;
    }

    @Override
    public void run() {
        LOGGER.debug("Proxy Started.");
        this.setLock(this);
        if (this.prepareClient()) {
            this.processRelay();
            this.close();
        } else {
            LOGGER.error("Proxy - client socket is null !");
        }
    }

    public void close() {
        try {
            if (this.m_ClientOutput != null) {
                this.m_ClientOutput.flush();
                this.m_ClientOutput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_ServerOutput != null) {
                this.m_ServerOutput.flush();
                this.m_ServerOutput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_ClientSocket != null) {
                this.m_ClientSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_ServerSocket != null) {
                this.m_ServerSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_ServerSocket = null;
        this.m_ClientSocket = null;
        LOGGER.debug("Proxy Closed.");
    }

    public void sendToClient(byte[] buffer) {
        this.sendToClient(buffer, buffer.length);
    }

    public void sendToClient(byte[] buffer, int len) {
        if (this.m_ClientOutput != null && len > 0 && len <= buffer.length) {
            try {
                this.m_ClientOutput.write(buffer, 0, len);
                this.m_ClientOutput.flush();
            }
            catch (IOException e) {
                LOGGER.error("Sending data to client");
            }
        }
    }

    public void sendToServer(byte[] buffer, int len) {
        if (this.m_ServerOutput != null && len > 0 && len <= buffer.length) {
            try {
                this.m_ServerOutput.write(buffer, 0, len);
                this.m_ServerOutput.flush();
            }
            catch (IOException e) {
                LOGGER.error("Sending data to server");
            }
        }
    }

    public boolean isActive() {
        return this.m_ClientSocket != null && this.m_ServerSocket != null;
    }

    public void connectToServer(String server, int port) throws IOException {
        if (server.equals("")) {
            this.close();
            LOGGER.error("Invalid Remote Host Name - Empty String !!!");
            return;
        }
        this.m_ServerSocket = new Socket(server, port);
        this.m_ServerSocket.setSoTimeout(10);
        LOGGER.debug("Connected to " + Utils.getSocketInfo(this.m_ServerSocket));
        this.prepareServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareServer() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_ServerInput = this.m_ServerSocket.getInputStream();
            this.m_ServerOutput = this.m_ServerSocket.getOutputStream();
        }
    }

    public boolean prepareClient() {
        if (this.m_ClientSocket == null) {
            return false;
        }
        try {
            this.m_ClientInput = this.m_ClientSocket.getInputStream();
            this.m_ClientOutput = this.m_ClientSocket.getOutputStream();
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Proxy - can't get I/O streams!");
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void processRelay() {
        try {
            byte SOCKS_Version = this.getByteFromClient();
            switch (SOCKS_Version) {
                case 4: {
                    this.comm = new Socks4Impl(this);
                    break;
                }
                case 5: {
                    this.comm = new Socks5Impl(this);
                    break;
                }
                default: {
                    LOGGER.error("Invalid SOKCS version : " + SOCKS_Version);
                    return;
                }
            }
            LOGGER.debug("Accepted SOCKS " + SOCKS_Version + " Request.");
            this.comm.authenticate(SOCKS_Version);
            this.comm.getClientCommand();
            switch (this.comm.socksCommand) {
                case 1: {
                    this.comm.connect();
                    this.relay();
                    break;
                }
                case 2: {
                    this.comm.bind();
                    this.relay();
                    break;
                }
                case 3: {
                    this.comm.udp();
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported Command, skipping... : " + this.comm.socksCommand);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public byte getByteFromClient() throws Exception {
        while (this.m_ClientSocket != null) {
            int b;
            try {
                b = this.m_ClientInput.read();
            }
            catch (InterruptedIOException e) {
                Thread.yield();
                continue;
            }
            return (byte)b;
        }
        throw new Exception("Interrupted Reading GetByteFromClient()");
    }

    public void relay() {
        boolean isActive = true;
        while (isActive) {
            int dlen = this.checkClientData();
            if (dlen < 0) {
                isActive = false;
            }
            if (dlen > 0) {
                this.logData(dlen, "Cli data");
                this.sendToServer(this.m_Buffer, dlen);
            }
            if ((dlen = this.checkServerData()) < 0) {
                isActive = false;
            }
            if (dlen > 0) {
                this.logData(dlen, "Srv data");
                this.sendToClient(this.m_Buffer, dlen);
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkClientData() {
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            if (this.m_ClientInput == null) {
                return -1;
            }
            try {
                dlen = this.m_ClientInput.read(this.m_Buffer, 0, 4096);
            }
            catch (InterruptedIOException e) {
                return 0;
            }
            catch (IOException e) {
                LOGGER.debug("Client connection Closed!");
                this.close();
                return -1;
            }
            if (dlen < 0) {
                this.close();
            }
            return dlen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkServerData() {
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            if (this.m_ServerInput == null) {
                return -1;
            }
            try {
                dlen = this.m_ServerInput.read(this.m_Buffer, 0, 4096);
            }
            catch (InterruptedIOException e) {
                return 0;
            }
            catch (IOException e) {
                LOGGER.debug("Server connection Closed!");
                this.close();
                return -1;
            }
            if (dlen < 0) {
                this.close();
            }
            return dlen;
        }
    }

    private void logData(int traffic, String dataSource) {
        LOGGER.debug(String.format("%s : %s >> <%s/%s:%d> : %d bytes.", dataSource, Utils.getSocketInfo(this.m_ClientSocket), this.comm.m_ServerIP.getHostName(), this.comm.m_ServerIP.getHostAddress(), this.comm.m_nServerPort, traffic));
    }

    public int getPort() {
        return this.m_ServerSocket.getPort();
    }
}

