/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Objects;
import org.bbottema.javasocksproxyserver.ProxyHandler;
import org.bbottema.javasocksproxyserver.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks4Impl {
    private static final Logger LOGGER = LoggerFactory.getLogger(Socks4Impl.class);
    final ProxyHandler m_Parent;
    final byte[] DST_Port = new byte[2];
    byte[] DST_Addr = new byte[4];
    byte SOCKS_Version = 0;
    byte socksCommand;
    private InetAddress m_ExtLocalIP = null;
    InetAddress m_ServerIP = null;
    int m_nServerPort = 0;
    InetAddress m_ClientIP = null;
    int m_nClientPort = 0;

    Socks4Impl(ProxyHandler Parent) {
        this.m_Parent = Parent;
    }

    public byte getSuccessCode() {
        return 90;
    }

    public byte getFailCode() {
        return 91;
    }

    @NotNull
    public String commName(byte code) {
        switch (code) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "BIND";
            }
            case 3: {
                return "UDP Association";
            }
        }
        return "Unknown Command";
    }

    @NotNull
    public String replyName(byte code) {
        switch (code) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "General SOCKS Server failure";
            }
            case 2: {
                return "Connection not allowed by ruleset";
            }
            case 3: {
                return "Network Unreachable";
            }
            case 4: {
                return "HOST Unreachable";
            }
            case 5: {
                return "Connection Refused";
            }
            case 6: {
                return "TTL Expired";
            }
            case 7: {
                return "Command not supported";
            }
            case 8: {
                return "Address Type not Supported";
            }
            case 9: {
                return "to 0xFF UnAssigned";
            }
            case 90: {
                return "Request GRANTED";
            }
            case 91: {
                return "Request REJECTED or FAILED";
            }
            case 92: {
                return "Request REJECTED - SOCKS server can't connect to Identd on the client";
            }
            case 93: {
                return "Request REJECTED - Client and Identd report diff user-ID";
            }
        }
        return "Unknown Command";
    }

    public boolean isInvalidAddress() {
        this.m_ServerIP = Utils.calcInetAddress(this.DST_Addr);
        this.m_nServerPort = Utils.calcPort(this.DST_Port[0], this.DST_Port[1]);
        this.m_ClientIP = this.m_Parent.m_ClientSocket.getInetAddress();
        this.m_nClientPort = this.m_Parent.m_ClientSocket.getPort();
        return this.m_ServerIP == null || this.m_nServerPort < 0;
    }

    protected byte getByte() {
        try {
            return this.m_Parent.getByteFromClient();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void authenticate(byte SOCKS_Ver) throws Exception {
        this.SOCKS_Version = SOCKS_Ver;
    }

    public void getClientCommand() throws Exception {
        this.socksCommand = this.getByte();
        this.DST_Port[0] = this.getByte();
        this.DST_Port[1] = this.getByte();
        for (int i = 0; i < 4; ++i) {
            this.DST_Addr[i] = this.getByte();
        }
        while (this.getByte() != 0) {
        }
        if (this.socksCommand < 1 || this.socksCommand > 2) {
            this.refuseCommand((byte)91);
            throw new Exception("Socks 4 - Unsupported Command : " + this.commName(this.socksCommand));
        }
        if (this.isInvalidAddress()) {
            this.refuseCommand((byte)92);
            throw new Exception("Socks 4 - Unknown Host/IP address '" + this.m_ServerIP.toString());
        }
        LOGGER.debug("Accepted SOCKS 4 Command: \"" + this.commName(this.socksCommand) + "\"");
    }

    public void replyCommand(byte ReplyCode) {
        LOGGER.debug("Socks 4 reply: \"" + this.replyName(ReplyCode) + "\"");
        byte[] REPLY = new byte[]{0, ReplyCode, this.DST_Port[0], this.DST_Port[1], this.DST_Addr[0], this.DST_Addr[1], this.DST_Addr[2], this.DST_Addr[3]};
        this.m_Parent.sendToClient(REPLY);
    }

    protected void refuseCommand(byte errorCode) {
        LOGGER.debug("Socks 4 - Refuse Command: \"" + this.replyName(errorCode) + "\"");
        this.replyCommand(errorCode);
    }

    public void connect() throws Exception {
        LOGGER.debug("Connecting...");
        try {
            this.m_Parent.connectToServer(this.m_ServerIP.getHostAddress(), this.m_nServerPort);
        }
        catch (IOException e) {
            this.refuseCommand(this.getFailCode());
            throw new Exception("Socks 4 - Can't connect to " + Utils.getSocketInfo(this.m_Parent.m_ServerSocket));
        }
        LOGGER.debug("Connected to " + Utils.getSocketInfo(this.m_Parent.m_ServerSocket));
        this.replyCommand(this.getSuccessCode());
    }

    public void bindReply(byte ReplyCode, InetAddress IA, int PT) {
        LOGGER.debug("Reply to Client : \"{}\"", (Object)this.replyName(ReplyCode));
        byte[] REPLY = new byte[8];
        byte[] IP = IA.getAddress();
        REPLY[0] = 0;
        REPLY[1] = ReplyCode;
        REPLY[2] = (byte)((PT & 0xFF00) >> 8);
        REPLY[3] = (byte)(PT & 0xFF);
        REPLY[4] = IP[0];
        REPLY[5] = IP[1];
        REPLY[6] = IP[2];
        REPLY[7] = IP[3];
        if (this.m_Parent.isActive()) {
            this.m_Parent.sendToClient(REPLY);
        } else {
            LOGGER.debug("Closed BIND Client Connection");
        }
    }

    @NotNull
    public InetAddress resolveExternalLocalIP() {
        InetAddress IP = null;
        if (this.m_ExtLocalIP != null) {
            try {
                Socket sct = new Socket(this.m_ExtLocalIP, this.m_Parent.getPort());
                IP = sct.getLocalAddress();
                sct.close();
                return this.m_ExtLocalIP;
            }
            catch (IOException e) {
                LOGGER.debug("WARNING !!! THE LOCAL IP ADDRESS WAS CHANGED !");
            }
        }
        String[] hosts = new String[]{"www.wikipedia.org", "www.google.com", "www.microsoft.com", "www.amazon.com", "www.zombo.com", "www.ebay.com"};
        ArrayList<Exception> bindExceptions = new ArrayList<Exception>();
        for (String host : hosts) {
            try (Socket sct = new Socket(InetAddress.getByName(host), 80);){
                IP = sct.getLocalAddress();
                break;
            }
            catch (Exception e) {
                bindExceptions.add(e);
            }
        }
        if (IP == null) {
            LOGGER.error("Error in BIND() - BIND reip Failed on all common hosts to determine external IP's");
            for (Exception bindException : bindExceptions) {
                LOGGER.debug(bindException.getMessage(), (Throwable)bindException);
            }
        }
        this.m_ExtLocalIP = IP;
        return Objects.requireNonNull(IP);
    }

    public void bind() throws IOException {
        int MyPort = 0;
        LOGGER.debug("Binding...");
        InetAddress MyIP = this.resolveExternalLocalIP();
        LOGGER.debug("Local IP : " + MyIP.toString());
        ServerSocket ssock = new ServerSocket(0);
        try {
            ssock.setSoTimeout(10);
            MyPort = ssock.getLocalPort();
        }
        catch (IOException e) {
            LOGGER.debug("Error in BIND() - Can't BIND at any Port");
            this.bindReply((byte)92, MyIP, MyPort);
            ssock.close();
            return;
        }
        LOGGER.debug("BIND at : <" + MyIP.toString() + ":" + MyPort + ">");
        this.bindReply((byte)90, MyIP, MyPort);
        Socket socket = null;
        while (socket == null) {
            if (this.m_Parent.checkClientData() >= 0) {
                LOGGER.debug("BIND - Client connection closed");
                ssock.close();
                return;
            }
            try {
                socket = ssock.accept();
                socket.setSoTimeout(10);
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
            Thread.yield();
        }
        this.m_ServerIP = socket.getInetAddress();
        this.m_nServerPort = socket.getPort();
        this.bindReply((byte)90, socket.getInetAddress(), socket.getPort());
        this.m_Parent.m_ServerSocket = socket;
        this.m_Parent.prepareServer();
        LOGGER.debug("BIND Connection from " + Utils.getSocketInfo(this.m_Parent.m_ServerSocket));
        ssock.close();
    }

    public void udp() throws IOException {
        LOGGER.debug("Error - Socks 4 don't support UDP Association!");
        LOGGER.debug("Check your Software please...");
        this.refuseCommand((byte)91);
    }
}

