/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver.junit;

import javax.net.ServerSocketFactory;
import org.bbottema.javasocksproxyserver.SocksServer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SockServerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final SocksServer socksServer;
    private final int port;
    private final ServerSocketFactory serverSocketFactory;

    public SockServerExtension(@NotNull Integer port) {
        this(port, ServerSocketFactory.getDefault());
    }

    public SockServerExtension(@NotNull Integer port, @NotNull ServerSocketFactory serverSocketFactory) {
        this.socksServer = new SocksServer(port, serverSocketFactory);
        this.port = port;
        this.serverSocketFactory = serverSocketFactory;
    }

    public void beforeAll(ExtensionContext context) {
        this.socksServer.start();
    }

    public void afterAll(ExtensionContext context) {
        this.socksServer.stop();
    }
}

