/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import org.bbottema.javasocksproxyserver.ProxyHandler;
import org.bbottema.javasocksproxyserver.Utils;
import org.bbottema.javasocksproxyserver.auth.Authenticator;
import org.bbottema.javasocksproxyserver.auth.DefaultAuthenticator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksServer.class);
    private volatile boolean stopped = false;
    private final int listenPort;
    @NotNull
    private ServerSocketFactory factory;
    @NotNull
    private Authenticator authenticator;

    public SocksServer() {
        this(1080);
    }

    public SocksServer(int listenPort) {
        this.listenPort = listenPort;
        this.factory = ServerSocketFactory.getDefault();
        this.authenticator = new DefaultAuthenticator();
    }

    public synchronized SocksServer setFactory(@NotNull ServerSocketFactory factory) {
        this.factory = factory;
        return this;
    }

    public synchronized SocksServer setAuthenticator(@NotNull Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public synchronized void start() {
        this.stopped = false;
        new Thread(new ServerProcess(this.listenPort, this.factory, this.authenticator)).start();
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    private class ServerProcess
    implements Runnable {
        protected final int port;
        private final ServerSocketFactory serverSocketFactory;
        private final Authenticator authenticator;

        public ServerProcess(int port, ServerSocketFactory serverSocketFactory, Authenticator authenticator) {
            this.port = port;
            this.serverSocketFactory = serverSocketFactory;
            this.authenticator = authenticator;
        }

        @Override
        public void run() {
            LOGGER.debug("SOCKS server started...");
            try {
                this.handleClients(this.port);
                LOGGER.debug("SOCKS server stopped...");
            }
            catch (IOException e) {
                LOGGER.debug("SOCKS server crashed...");
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClients(int port) throws IOException {
            ServerSocket listenSocket = this.serverSocketFactory.createServerSocket(port);
            listenSocket.setSoTimeout(200);
            LOGGER.debug("SOCKS server listening at port: {}", (Object)listenSocket.getLocalPort());
            while (true) {
                SocksServer socksServer = SocksServer.this;
                synchronized (socksServer) {
                    if (SocksServer.this.stopped) {
                        break;
                    }
                }
                this.handleNextClient(listenSocket);
            }
            try {
                listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void handleNextClient(ServerSocket listenSocket) {
            try {
                Socket clientSocket = listenSocket.accept();
                clientSocket.setSoTimeout(200);
                LOGGER.debug("Connection from : {}", (Object)Utils.getSocketInfo(clientSocket));
                new Thread(new ProxyHandler(clientSocket, this.authenticator)).start();
            }
            catch (InterruptedIOException clientSocket) {
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

