/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;

public abstract class AbstractInterceptor {
    private final FastDateFormat defaultFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    protected String showSql(@NotNull Configuration configuration, @NotNull BoundSql boundSql) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(boundSql);
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql();
        if (parameterMappings != null && !parameterMappings.isEmpty() && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    protected String getParameterValue(Object obj) {
        String value = null;
        value = obj instanceof String ? "'" + obj.toString() + "'" : (obj instanceof Date ? "'" + this.defaultFormat.format((Date)obj) + "'" : (obj != null ? obj.toString() : ""));
        return value;
    }
}

