/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost;

import com.github.blackbk.sqlboost.appendtime.TimeAppenderInterceptor;
import com.github.blackbk.sqlboost.mapper.CheckPropertyMapper;
import com.github.blackbk.sqlboost.mapper.UacMapper;
import com.github.blackbk.sqlboost.property.TimeAppenderPropertyResolver;
import com.github.blackbk.sqlboost.property.UacPropertyResolver;
import com.github.blackbk.sqlboost.uac.UacInterceptor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(basePackageClasses={UacMapper.class, CheckPropertyMapper.class})
public class SqlBoostConfiguration {
    @Bean
    public UacPropertyResolver uacPropertyResolver() {
        return new UacPropertyResolver();
    }

    @Bean
    public TimeAppenderPropertyResolver timeAppenderPropertyResolver() {
        return new TimeAppenderPropertyResolver();
    }

    @Bean
    public UacInterceptor uacInterceptor() {
        return new UacInterceptor();
    }

    @Bean
    public TimeAppenderInterceptor timeAppenderInterceptor() {
        return new TimeAppenderInterceptor();
    }

    @Configuration
    public static class SqlBoostCheckConfiguration {
        @Resource
        private CheckPropertyMapper checkPropertyMapper;
        @Resource
        private UacMapper uacMapper;
        @Autowired
        private UacPropertyResolver uacPropertyResolver;
        @Autowired
        private UacInterceptor uacInterceptor;
        @Autowired
        private TimeAppenderInterceptor timeAppenderInterceptor;

        @PostConstruct
        public void init() {
            if (this.uacPropertyResolver.isEnable()) {
                this.uacPropertyResolver.checkExtra();
            }
            this.uacInterceptor.prepare();
            this.timeAppenderInterceptor.prepare();
        }
    }
}

