/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost.appendtime;

import com.github.blackbk.sqlboost.AbstractInterceptor;
import com.github.blackbk.sqlboost.SqlBoostSwitch;
import com.github.blackbk.sqlboost.appendtime.TimeDataTypeEnum;
import com.github.blackbk.sqlboost.exception.SqlBoostException;
import com.github.blackbk.sqlboost.mapper.CheckPropertyMapper;
import com.github.blackbk.sqlboost.property.TimeAppenderProperty;
import com.github.blackbk.sqlboost.property.TimeAppenderPropertyResolver;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TimeAppenderInterceptor
extends AbstractInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(TimeAppenderInterceptor.class);
    private static final Set<String> stringDataType = new HashSet<String>(Arrays.asList("char", "varchar", "tinytext", "text", "mediumtext", "longtext", "tinyblob", "mediumblob", "blob", "longblob"));
    protected FastDateFormat dateTimeFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    protected FastDateFormat dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    protected FastDateFormat timeFormat = FastDateFormat.getInstance((String)"hh:mm:ss");
    protected FastDateFormat yearFormat = FastDateFormat.getInstance((String)"yyyy");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TimeAppenderPropertyResolver propertyResolver;
    private TimeAppenderProperty property;
    private CheckPropertyMapper checkPropertyMapper;
    private boolean enable;
    private String createTimeColumn;
    private String updateTimeColumn;
    private final Map<String, CreateTable> tabelDefineMap = new ConcurrentHashMap<String, CreateTable>();
    private final Map<ColumnKey, ColumnType> columnTypeMap = new ConcurrentHashMap<ColumnKey, ColumnType>();
    private final Set<String> excludeTableSet = new HashSet<String>();
    private boolean prepared;

    public synchronized void prepare() {
        if (this.prepared) {
            return;
        }
        this.checkPropertyMapper = (CheckPropertyMapper)this.applicationContext.getBean(CheckPropertyMapper.class);
        this.prepared = true;
    }

    @PostConstruct
    public void init() {
        this.property = this.propertyResolver.getProperty();
        this.enable = this.property.isEnable();
        this.createTimeColumn = StringUtils.isNotBlank((CharSequence)this.property.getCreateTimeColumn()) ? this.property.getCreateTimeColumn().trim() : "create_time";
        this.updateTimeColumn = StringUtils.isNotBlank((CharSequence)this.property.getUpdateTimeColumn()) ? this.property.getUpdateTimeColumn().trim() : "update_time";
        String[] excludeTables = this.property.getExcludeTables();
        if (excludeTables != null) {
            for (String excludeTable : excludeTables) {
                if (!StringUtils.isNotBlank((CharSequence)excludeTable)) continue;
                this.excludeTableSet.add(excludeTable.trim());
            }
        }
        if (this.enable) {
            log.info("Sql Boost: time appender\u5df2\u542f\u7528.");
        } else {
            log.info("Sql Boost: time appender\u672a\u542f\u7528.");
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.prepared) {
            this.prepare();
        }
        if (!this.enable) {
            return invocation.proceed();
        }
        if (!SqlBoostSwitch.isTimeAppenderActive()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        String rawSql = statementHandler.getBoundSql().getSql();
        if (StringUtils.startsWithIgnoreCase((CharSequence)rawSql, (CharSequence)"show create table")) {
            return invocation.proceed();
        }
        Statements sts = null;
        try {
            sts = CCJSqlParserUtil.parseStatements((String)rawSql);
        }
        catch (JSQLParserException e) {
            log.warn("SQL\u89e3\u6790\u5931\u8d25\uff0c\u8df3\u8fc7\u8be5SQL\uff1a\"" + rawSql.replaceAll("\n", "") + "\"\uff0c\u89e3\u6790\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return invocation.proceed();
        }
        boolean updateAffected = false;
        boolean insertAffected = false;
        if (sts != null && sts.getStatements() != null) {
            for (Statement statement : sts.getStatements()) {
                if (statement instanceof Update) {
                    updateAffected = this.processUpdate((Update)statement);
                    continue;
                }
                if (!(statement instanceof Insert)) continue;
                insertAffected = this.processInsert((Insert)statement);
            }
        }
        if (updateAffected || insertAffected) {
            String newSql = sts.toString();
            BoundSql boundSql = statementHandler.getBoundSql();
            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, newSql);
        }
        return invocation.proceed();
    }

    private boolean processUpdate(Update update) {
        if (update == null || update.getColumns() == null) {
            return false;
        }
        String tableName = update.getTable().getName();
        if (this.excludeTableSet.contains(tableName)) {
            return false;
        }
        if (!this.tabelDefineMap.containsKey(tableName)) {
            this.prepareTableDefine(tableName);
        }
        for (Column col : update.getColumns()) {
            if (!Objects.equals(col.getColumnName(), this.updateTimeColumn)) continue;
            return false;
        }
        Expression updateTimeValue = null;
        updateTimeValue = this.getCurrentTimeValue(tableName, this.updateTimeColumn);
        if (updateTimeValue != null) {
            Column updateColumn = this.buildColumn(update.getTable(), this.updateTimeColumn);
            update.getColumns().add(updateColumn);
            update.getExpressions().add(updateTimeValue);
            return true;
        }
        return false;
    }

    private boolean processInsert(Insert insert) {
        boolean processed = false;
        if (insert == null) {
            return false;
        }
        String tableName = insert.getTable().getName();
        if (this.excludeTableSet.contains(tableName)) {
            return false;
        }
        if (!this.tabelDefineMap.containsKey(tableName)) {
            this.prepareTableDefine(tableName);
        }
        boolean hasCreate = false;
        boolean hasUpdate = false;
        if (insert.getSetColumns() != null) {
            hasCreate = this.constainsColumn(insert.getSetColumns(), this.createTimeColumn);
            hasUpdate = this.constainsColumn(insert.getSetColumns(), this.updateTimeColumn);
            Expression createTimeValue = null;
            Expression updateTimeValue = null;
            if (!hasCreate && (createTimeValue = this.getCurrentTimeValue(tableName, this.createTimeColumn)) != null) {
                insert.getSetColumns().add(this.buildColumn(insert.getTable(), this.createTimeColumn));
                insert.getSetExpressionList().add(createTimeValue);
                processed = true;
            }
            if (!hasUpdate && (updateTimeValue = this.getCurrentTimeValue(tableName, this.updateTimeColumn)) != null) {
                insert.getSetColumns().add(this.buildColumn(insert.getTable(), this.updateTimeColumn));
                insert.getSetExpressionList().add(updateTimeValue);
                processed = true;
            }
        }
        hasCreate = false;
        hasUpdate = false;
        ArrayList<ExpressionList> values = new ArrayList<ExpressionList>();
        if (insert.getItemsList() instanceof MultiExpressionList) {
            values.addAll(((MultiExpressionList)insert.getItemsList()).getExprList());
        } else if (insert.getItemsList() instanceof ExpressionList) {
            values.add((ExpressionList)insert.getItemsList());
        }
        if (insert.getColumns() != null) {
            Expression updateTimeValue;
            Expression createTimeValue;
            hasCreate = this.constainsColumn(insert.getColumns(), this.createTimeColumn);
            hasUpdate = this.constainsColumn(insert.getColumns(), this.updateTimeColumn);
            if (!hasCreate && (createTimeValue = this.getCurrentTimeValue(tableName, this.createTimeColumn)) != null) {
                insert.getColumns().add(this.buildColumn(insert.getTable(), this.createTimeColumn));
                values.forEach(v -> v.getExpressions().add(createTimeValue));
                processed = true;
            }
            if (!hasUpdate && (updateTimeValue = this.getCurrentTimeValue(tableName, this.updateTimeColumn)) != null) {
                insert.getColumns().add(this.buildColumn(insert.getTable(), this.updateTimeColumn));
                values.forEach(v -> v.getExpressions().add(updateTimeValue));
                processed = true;
            }
        }
        return processed;
    }

    private Expression getCurrentTimeValue(String tableName, String columnName) {
        LongValue time = null;
        ColumnType columnType = this.columnTypeMap.get(new ColumnKey(tableName, columnName));
        if (columnType == null) {
            return time;
        }
        String dataType = columnType.getDatatype();
        TimeDataTypeEnum timeDataType = TimeDataTypeEnum.getEnum(dataType);
        if (timeDataType == null && dataType != null && StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"bigint")) {
            time = new LongValue(new Date().getTime());
        }
        if (timeDataType == null && dataType != null && stringDataType.contains(dataType.toLowerCase())) {
            String timeStr = this.dateTimeFormat.format(new Date());
            if (columnType.getStrLength() != null && columnType.getStrLength() >= 0 && columnType.getStrLength() < timeStr.length()) {
                timeStr = timeStr.substring(0, columnType.getStrLength());
            }
            time = new StringValue(timeStr);
        }
        if (timeDataType != null) {
            switch (timeDataType) {
                case DATE: {
                    time = new StringValue(this.dateFormat.format(new Date()));
                    break;
                }
                case TIMESTAMP: 
                case DATETIME: {
                    time = new StringValue(this.dateTimeFormat.format(new Date()));
                    break;
                }
                case TIME: {
                    time = new StringValue(this.timeFormat.format(new Date()));
                    break;
                }
                case YEAR: {
                    time = new StringValue(this.yearFormat.format(new Date()));
                }
            }
        }
        return time;
    }

    private Column buildColumn(@NotNull Table table, @NotNull @NotBlank String columnName) {
        if (table.getAlias() != null && StringUtils.isNotBlank((CharSequence)table.getAlias().getName())) {
            return new Column(new Table(table.getAlias().getName()), columnName);
        }
        return new Column(null, columnName);
    }

    private boolean constainsColumn(List<Column> columnList, String columnName) {
        if (columnList == null || columnList.isEmpty()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)columnName)) {
            return false;
        }
        for (Column col : columnList) {
            if (!Objects.equals(col.getColumnName(), columnName)) continue;
            return true;
        }
        return false;
    }

    private void prepareTableDefine(String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        CreateTable createTable = null;
        try {
            Map<String, String> infoMap = this.checkPropertyMapper.showTable(tableName);
            if (infoMap == null || infoMap.isEmpty() || !infoMap.containsKey("Table") || !infoMap.containsKey("Create Table")) {
                throw new SqlBoostException("\u83b7\u53d6\u89e3\u6790\u8868\u7ed3\u6784\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u8868\uff1a" + tableName);
            }
            createTable = (CreateTable)CCJSqlParserUtil.parse((String)infoMap.get("Create Table"));
        }
        catch (Exception e) {
            throw new SqlBoostException("\u83b7\u53d6\u89e3\u6790\u8868\u7ed3\u6784\u65f6\u53d1\u751f\u9519\u8bef.", e);
        }
        if (createTable != null) {
            this.tabelDefineMap.putIfAbsent(tableName, createTable);
            this.prepareColumnType(tableName, createTable.getColumnDefinitions());
        }
    }

    private void prepareColumnType(String tableName, List<ColumnDefinition> columnDefinitions) {
        if (tableName == null || columnDefinitions == null) {
            return;
        }
        for (ColumnDefinition columnDefinition : columnDefinitions) {
            String column = StringUtils.removeEnd((String)StringUtils.removeStart((String)columnDefinition.getColumnName(), (String)"`"), (String)"`");
            ColumnKey key = new ColumnKey(tableName, column);
            ColumnType value = new ColumnType();
            value.setDatatype(columnDefinition.getColDataType().getDataType());
            if (stringDataType.contains(value.getDatatype()) && !CollectionUtils.isEmpty((Collection)columnDefinition.getColDataType().getArgumentsStringList())) {
                try {
                    value.setStrLength(Integer.valueOf((String)columnDefinition.getColDataType().getArgumentsStringList().get(0)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.columnTypeMap.putIfAbsent(key, value);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private static class ColumnType {
        String datatype;
        Integer strLength;

        public ColumnType() {
        }

        public ColumnType(String datatype, int strLength) {
            this.datatype = datatype;
            this.strLength = strLength;
        }

        public String getDatatype() {
            return this.datatype;
        }

        public void setDatatype(String datatype) {
            this.datatype = datatype;
        }

        public Integer getStrLength() {
            return this.strLength;
        }

        public void setStrLength(Integer strLength) {
            this.strLength = strLength;
        }
    }

    private static class ColumnKey {
        String table;
        String column;

        public ColumnKey() {
        }

        public ColumnKey(String table, String column) {
            this.table = table;
            this.column = column;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnKey columnKey = (ColumnKey)o;
            return Objects.equals(this.table, columnKey.table) && Objects.equals(this.column, columnKey.column);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.column);
        }
    }
}

