/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost.property;

import com.github.blackbk.sqlboost.property.AbstractPropertyResolver;
import com.github.blackbk.sqlboost.property.TimeAppenderProperty;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class TimeAppenderPropertyResolver
extends AbstractPropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(TimeAppenderPropertyResolver.class);
    private static final String ENV_KEY_PREFIX = "sql-boost.time-appender.";
    @Autowired
    private Environment env;
    private TimeAppenderProperty property;

    @PostConstruct
    public void init() {
        TimeAppenderProperty newProperty = new TimeAppenderProperty();
        newProperty.setEnable((Boolean)this.env.getProperty("sql-boost.time-appender.enable", Boolean.class, (Object)false));
        newProperty.setCreateTimeColumn((String)this.env.getProperty("sql-boost.time-appender.createTimeColumn", String.class, (Object)"create_time"));
        newProperty.setUpdateTimeColumn((String)this.env.getProperty("sql-boost.time-appender.updateTimeColumn", String.class, (Object)"update_time"));
        String excludeTKey = "sql-boost.time-appender.excludeTables";
        ArrayList<String> excludeTs = new ArrayList<String>();
        int i = 0;
        while (this.env.containsProperty(excludeTKey + this.getNo(i))) {
            String value = (String)this.env.getProperty(excludeTKey + this.getNo(i), String.class);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                excludeTs.add(value);
            }
            ++i;
        }
        newProperty.setExcludeTables(excludeTs.toArray(new String[0]));
        this.property = newProperty;
    }

    public TimeAppenderProperty getProperty() {
        return this.property;
    }
}

