/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost.property;

import com.github.blackbk.sqlboost.exception.SqlBoostException;
import com.github.blackbk.sqlboost.mapper.CheckPropertyMapper;
import com.github.blackbk.sqlboost.property.AbstractPropertyResolver;
import com.github.blackbk.sqlboost.property.UacProperty;
import com.github.blackbk.sqlboost.uac.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.create.table.NamedConstraint;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class UacPropertyResolver
extends AbstractPropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(UacPropertyResolver.class);
    private static final String ENV_KEY_PREFIX = "sql-boost.uac.";
    private static final String DEFAULT_PRIMARY_COLUMN = "id";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Environment env;
    private UacProperty property;
    private CheckPropertyMapper checkPropertyMapper;
    private boolean enable;
    private boolean allowMultiQueries;
    private Rule rule;
    private Map<String, TableInfo> tableInfoMap = new ConcurrentHashMap<String, TableInfo>();

    @PostConstruct
    public void init() {
        String dsUrl;
        UacProperty newProperty = new UacProperty();
        newProperty.setEnable((Boolean)this.env.getProperty("sql-boost.uac.enable", Boolean.class, (Object)false));
        newProperty.setRules(new ArrayList<UacProperty.SourceProperty>());
        String rulesKey = "sql-boost.uac.rules";
        ArrayList<UacProperty.SourceProperty> sources = new ArrayList<UacProperty.SourceProperty>();
        int i = 0;
        boolean isSourceValid = false;
        do {
            isSourceValid = false;
            String sKey = rulesKey + this.getNo(i) + ".";
            UacProperty.SourceProperty source = new UacProperty.SourceProperty();
            source.setSourceTable((String)this.env.getProperty(sKey + "sourceTable", String.class));
            source.setSourceColumn((String)this.env.getProperty(sKey + "sourceColumn", String.class));
            source.setRootColumn((String)this.env.getProperty(sKey + "rootColumn", String.class));
            source.setPrimaryColumn((String)this.env.getProperty(sKey + "primaryColumn", String.class));
            ArrayList<UacProperty.TargetProperty> associations = new ArrayList<UacProperty.TargetProperty>();
            int j = 0;
            boolean isTargetValid = false;
            do {
                isTargetValid = false;
                String tKey = sKey + "association" + this.getNo(j) + ".";
                UacProperty.TargetProperty target = new UacProperty.TargetProperty();
                target.setTargetTable((String)this.env.getProperty(tKey + "targetTable", String.class));
                target.setTargetColumn((String)this.env.getProperty(tKey + "targetColumn", String.class));
                target.setAssoColumn((String)this.env.getProperty(tKey + "assoColumn", String.class));
                if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{target.getTargetTable(), target.getTargetColumn(), target.getAssoColumn()})) {
                    associations.add(target);
                    isTargetValid = true;
                }
                ++j;
            } while (isTargetValid);
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{source.getSourceColumn(), source.getSourceColumn(), source.getRootColumn(), source.getPrimaryColumn()})) {
                isSourceValid = true;
            }
            if (!associations.isEmpty()) {
                source.setAssociation(associations);
                isSourceValid = true;
            }
            if (isSourceValid) {
                sources.add(source);
            }
            ++i;
        } while (isSourceValid);
        if (!sources.isEmpty()) {
            newProperty.setRules(sources);
        }
        this.property = newProperty;
        if (this.env.containsProperty("spring.datasource.url") && (dsUrl = this.env.getProperty("spring.datasource.url")) != null && dsUrl.contains("allowMultiQueries=true")) {
            this.allowMultiQueries = true;
        }
        this.enable = this.property.isEnable() && this.property.getRules() != null && !this.property.getRules().isEmpty();
        if (this.enable) {
            this.checkProperty(this.property);
            this.checkCyclic(this.property);
        }
        this.rule = new Rule(this.property);
    }

    private synchronized void initMapper() {
        if (this.checkPropertyMapper == null) {
            this.checkPropertyMapper = (CheckPropertyMapper)this.applicationContext.getBean(CheckPropertyMapper.class);
        }
    }

    public UacProperty getProperty() {
        return this.property;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isAllowMultiQueries() {
        return this.allowMultiQueries;
    }

    public Rule getRule() {
        return this.rule;
    }

    private void checkProperty(UacProperty uacProperty) {
        HashMap<String, String> primaryMap = new HashMap<String, String>();
        for (UacProperty.SourceProperty s : uacProperty.getRules()) {
            if (StringUtils.isBlank((CharSequence)s.getPrimaryColumn())) {
                s.setPrimaryColumn(DEFAULT_PRIMARY_COLUMN);
            }
            if (primaryMap.containsKey(s.getSourceTable())) {
                if (!Objects.equals(primaryMap.get(s.getSourceTable()), s.getPrimaryColumn())) {
                    throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u80fd\u7ed9\u540c\u4e00\u5f20\u8868\u8bbe\u7f6e\u591a\u4e2aprimaryColumn\uff0c\u8868\uff1a" + s.getSourceTable() + "\uff0cprimaryColum\uff1a" + (String)primaryMap.get(s.getSourceTable()) + "\u3001" + s.getPrimaryColumn());
                }
            } else {
                primaryMap.put(s.getSourceTable(), s.getPrimaryColumn());
            }
            if (StringUtils.isBlank((CharSequence)s.getRootColumn())) {
                throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0crootColumn\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{s.getSourceTable(), s.getSourceColumn()})) {
                throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0csourceTable\u3001sourceColumn\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (s.getAssociation() == null || s.getAssociation().isEmpty()) {
                throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0cassociation\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            for (UacProperty.TargetProperty t : s.getAssociation()) {
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{t.getTargetTable(), t.getTargetColumn(), t.getAssoColumn()})) continue;
                throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0ctargetTable\u3001targetColumn\u3001assoColumn\u4e0d\u80fd\u4e3a\u7a7a.");
            }
        }
    }

    private void checkCyclic(UacProperty uacProperty) {
        DirectedAcyclicGraph dag = new DirectedAcyclicGraph(DefaultEdge.class);
        for (UacProperty.SourceProperty s : uacProperty.getRules()) {
            for (UacProperty.TargetProperty t : s.getAssociation()) {
                try {
                    if (StringUtils.equals((CharSequence)s.getSourceTable(), (CharSequence)t.getTargetTable())) {
                        throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0csourceTable\u4e0d\u80fd\u548ctargetTable\u4e3a\u540c\u4e00\u5f20\u8868\uff0c\u76f8\u540c\u7684\u8868\uff1a" + s.getSourceTable());
                    }
                    if (!dag.containsVertex((Object)s.getSourceTable())) {
                        dag.addVertex((Object)s.getSourceTable());
                    }
                    if (!dag.containsVertex((Object)t.getTargetTable())) {
                        dag.addVertex((Object)t.getTargetTable());
                    }
                    dag.addEdge((Object)s.getSourceTable(), (Object)t.getTargetTable());
                }
                catch (IllegalArgumentException e) {
                    throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0c\u8868\u66f4\u65b0\u987a\u5e8f\u94fe\u4e2d\u5b58\u5728\u73af\u8def\uff0c\u6709\u4ea7\u751f\u6570\u636e\u5e93\u6b7b\u9501\u7684\u53ef\u80fd\uff0c\u5b58\u5728\u73af\u8def\u7684\u8868\uff1a" + s.getSourceTable() + "," + t.getTargetTable());
                }
            }
        }
    }

    public void checkExtra() {
        this.checkTableAndColumn(this.property);
    }

    private void checkTableAndColumn(UacProperty uacProperty) {
        for (UacProperty.SourceProperty s : uacProperty.getRules()) {
            this.doCheckTableAndColumn(s.getSourceTable(), s.getPrimaryColumn(), Arrays.asList(s.getRootColumn(), s.getSourceColumn()));
            for (UacProperty.TargetProperty t : s.getAssociation()) {
                this.doCheckTableAndColumn(t.getTargetTable(), Arrays.asList(t.getAssoColumn(), t.getTargetColumn()));
            }
        }
    }

    private void doCheckTableAndColumn(@NotNull String tableName, List<String> columns) {
        this.doCheckTableAndColumn(tableName, null, columns);
    }

    private void doCheckTableAndColumn(@NotNull String tableName, String primaryColumn, List<String> columns) {
        if (!this.tableInfoMap.containsKey(tableName)) {
            this.tableInfoMap.put(tableName, this.buildTableInfo(tableName));
        }
        TableInfo tableInfo = this.tableInfoMap.get(tableName);
        if (primaryColumn != null && !Objects.equals(tableInfo.getPrimaryColumn(), primaryColumn)) {
            throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0cprimaryColumn\u9519\u8bef\uff0c" + primaryColumn + "\u4e0d\u662f\u8868" + tableName + "\u7684\u4e3b\u952e.");
        }
        if (columns != null) {
            for (String col : columns) {
                if (tableInfo.getColumns().contains(col)) continue;
                throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0c" + col + "\u4e0d\u662f\u8868" + tableName + "\u7684\u5217.");
            }
        }
    }

    private TableInfo buildTableInfo(String tableName) {
        Map<String, String> infoMap;
        if (this.checkPropertyMapper == null) {
            this.initMapper();
        }
        if ((infoMap = this.checkPropertyMapper.showTable(tableName)) == null || infoMap.isEmpty() || !infoMap.containsKey("Table") || !infoMap.containsKey("Create Table")) {
            throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0csourceTable\u9519\u8bef\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u8868\uff1a" + tableName);
        }
        CreateTable createTable = null;
        try {
            createTable = (CreateTable)CCJSqlParserUtil.parse((String)infoMap.get("Create Table"));
        }
        catch (JSQLParserException e) {
            throw new SqlBoostException("uac\u89c4\u5219\u914d\u7f6e\u89e3\u6790\u9519\u8bef\uff0cSQL\u89e3\u6790\u5f02\u5e38\uff0csql\uff1a" + infoMap.get("Create Table"), e);
        }
        HashSet<String> columns = new HashSet<String>();
        for (Object cd : createTable.getColumnDefinitions()) {
            String col = cd.getColumnName();
            col = col.replaceAll("`", "");
            columns.add(col);
        }
        String primaryColumn = null;
        if (createTable.getIndexes() != null) {
            for (Index index : createTable.getIndexes()) {
                if (!(index instanceof NamedConstraint) || !"PRIMARY KEY".equalsIgnoreCase(index.getType())) continue;
                primaryColumn = (String)index.getColumnsNames().get(0);
                primaryColumn = primaryColumn.replaceAll("`", "");
            }
        }
        TableInfo tableInfo = new TableInfo(tableName, primaryColumn, columns);
        return tableInfo;
    }

    private static class TableInfo {
        String tableName;
        String primaryColumn;
        Set<String> columns;

        public TableInfo() {
        }

        public TableInfo(@NotNull String tableName, @NotNull String primaryColumn, @NotNull Set<String> columns) {
            this.tableName = tableName;
            this.primaryColumn = primaryColumn;
            this.columns = columns != null ? columns : new HashSet<String>();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableInfo tableInfo = (TableInfo)o;
            return Objects.equals(this.tableName, tableInfo.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getPrimaryColumn() {
            return this.primaryColumn;
        }

        public void setPrimaryColumn(String primaryColumn) {
            this.primaryColumn = primaryColumn;
        }

        public Set<String> getColumns() {
            return this.columns;
        }

        public void setColumns(Set<String> columns) {
            this.columns = columns;
        }
    }
}

