/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost.uac;

import com.github.blackbk.sqlboost.property.UacProperty;
import com.github.blackbk.sqlboost.uac.SourceTable;
import com.github.blackbk.sqlboost.uac.TargetTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Rule {
    private Map<SourceTable, Set<TargetTable>> ruleMap = new HashMap<SourceTable, Set<TargetTable>>();
    private Map<SourceKey, Set<SourceTable>> sourceRuleMap = new HashMap<SourceKey, Set<SourceTable>>();
    private Map<String, Set<String>> sourceTabColMap = new HashMap<String, Set<String>>();

    public Rule(UacProperty uacProperty) {
        Object key;
        if (uacProperty == null || uacProperty.getRules() == null || uacProperty.getRules().isEmpty()) {
            return;
        }
        for (UacProperty.SourceProperty s : uacProperty.getRules()) {
            if (s.getAssociation() == null || s.getAssociation().isEmpty()) continue;
            key = new SourceTable(s.getSourceTable(), s.getPrimaryColumn(), s.getRootColumn(), s.getSourceColumn());
            if (!this.ruleMap.containsKey(key)) {
                this.ruleMap.put((SourceTable)key, new HashSet());
            }
            Set<TargetTable> value = this.ruleMap.get(key);
            for (UacProperty.TargetProperty t : s.getAssociation()) {
                TargetTable target = new TargetTable(t.getTargetTable(), t.getAssoColumn(), t.getTargetColumn());
                value.add(target);
            }
        }
        for (SourceTable target : this.ruleMap.keySet()) {
            key = new SourceKey(target.getTable(), target.getSourceColumn());
            if (!this.sourceRuleMap.containsKey(key)) {
                this.sourceRuleMap.put((SourceKey)key, new HashSet());
            }
            this.sourceRuleMap.get(key).add(target);
        }
        for (SourceKey sourceKey : this.sourceRuleMap.keySet()) {
            key = sourceKey.getTable();
            if (!this.sourceTabColMap.containsKey(key)) {
                this.sourceTabColMap.put((String)key, new HashSet());
            }
            this.sourceTabColMap.get(key).add(sourceKey.getSourceColumn());
        }
    }

    public boolean constainsAssociation(String table) {
        return this.sourceTabColMap.containsKey(table);
    }

    public boolean constainsAssociation(String table, String column) {
        return this.sourceRuleMap.containsKey(new SourceKey(table, column));
    }

    public Set<String> getSourceColumn(String table) {
        return this.sourceTabColMap.get(table);
    }

    public boolean constainsSourceRule(String table, String column) {
        return this.sourceRuleMap.containsKey(new SourceKey(table, column));
    }

    public Set<SourceTable> getSourceRule(String table, String column) {
        return this.sourceRuleMap.get(new SourceKey(table, column));
    }

    public boolean constainsTargetRule(String table, String root, String column) {
        return this.ruleMap.containsKey(new SourceTable(table, root, column));
    }

    public boolean constainsTargetRule(SourceTable sourceTable) {
        return this.ruleMap.containsKey(sourceTable);
    }

    public Set<TargetTable> getTargetRule(String table, String root, String column) {
        return this.ruleMap.get(new SourceTable(table, root, column));
    }

    public Set<TargetTable> getTargetRule(SourceTable sourceTable) {
        return this.ruleMap.get(sourceTable);
    }

    private static class SourceKey {
        private String table;
        private String sourceColumn;

        SourceKey(String table, String sourceColumn) {
            this.table = table;
            this.sourceColumn = sourceColumn;
        }

        String getTable() {
            return this.table;
        }

        String getSourceColumn() {
            return this.sourceColumn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceKey sourceKey = (SourceKey)o;
            return Objects.equals(this.table, sourceKey.table) && Objects.equals(this.sourceColumn, sourceKey.sourceColumn);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.sourceColumn);
        }
    }
}

