/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackbk.sqlboost.uac;

import com.github.blackbk.sqlboost.AbstractInterceptor;
import com.github.blackbk.sqlboost.SqlBoostSwitch;
import com.github.blackbk.sqlboost.exception.SqlBoostException;
import com.github.blackbk.sqlboost.mapper.UacMapper;
import com.github.blackbk.sqlboost.property.UacPropertyResolver;
import com.github.blackbk.sqlboost.uac.AfterGetFromSourceConverter;
import com.github.blackbk.sqlboost.uac.BeforeUpdateTargetConverter;
import com.github.blackbk.sqlboost.uac.ConverterOrder;
import com.github.blackbk.sqlboost.uac.Rule;
import com.github.blackbk.sqlboost.uac.SourceTable;
import com.github.blackbk.sqlboost.uac.TargetTable;
import com.github.blackbk.sqlboost.uac.UpdateParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class UacInterceptor
extends AbstractInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(UacInterceptor.class);
    @Autowired
    private UacPropertyResolver propertyResolver;
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<ConverterKey, List<BeforeUpdateTargetConverter>> targetConverterMap = new HashMap<ConverterKey, List<BeforeUpdateTargetConverter>>();
    private final Map<ConverterKey, List<AfterGetFromSourceConverter>> sourceConverterMap = new HashMap<ConverterKey, List<AfterGetFromSourceConverter>>();
    private UacMapper uacMapper;
    private boolean enable;
    private boolean allowMultiQueries;
    private Rule rule;
    private boolean prepared = false;

    public synchronized void prepare() {
        List<Object> value;
        ConverterKey key;
        if (this.prepared) {
            return;
        }
        this.uacMapper = (UacMapper)this.applicationContext.getBean(UacMapper.class);
        Map tarConBeanMap = this.applicationContext.getBeansOfType(BeforeUpdateTargetConverter.class);
        Map souConBeanMap = this.applicationContext.getBeansOfType(AfterGetFromSourceConverter.class);
        ArrayList targetConverters = new ArrayList(tarConBeanMap.values());
        ArrayList sourceConverters = new ArrayList(souConBeanMap.values());
        for (ConverterOrder c : targetConverters) {
            key = new ConverterKey(c.table(), c.column());
            value = null;
            if (!this.targetConverterMap.containsKey(key)) {
                value = new ArrayList<ConverterOrder>();
                value.add(c);
                this.targetConverterMap.put(key, value);
                continue;
            }
            value = this.targetConverterMap.get(key);
            value.add(c);
            value.sort(Comparator.comparingInt(ConverterOrder::order));
        }
        for (ConverterOrder c : sourceConverters) {
            key = new ConverterKey(c.table(), c.column());
            value = null;
            if (!this.sourceConverterMap.containsKey(key)) {
                value = new ArrayList();
                value.add(c);
                this.sourceConverterMap.put(key, value);
                continue;
            }
            value = this.sourceConverterMap.get(key);
            value.add(c);
            value.sort(Comparator.comparingInt(ConverterOrder::order));
        }
        this.prepared = true;
    }

    @PostConstruct
    public void init() {
        this.rule = this.propertyResolver.getRule();
        this.enable = this.propertyResolver.isEnable();
        this.allowMultiQueries = this.propertyResolver.isAllowMultiQueries();
        if (this.enable) {
            log.info("Sql Boost: uac\u5df2\u542f\u7528.");
        } else {
            log.info("Sql Boost: uac\u672a\u542f\u7528.");
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.prepared) {
            this.prepare();
        }
        if (!this.enable) {
            return invocation.proceed();
        }
        if (!SqlBoostSwitch.isUacActive()) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        SqlCommandType sqlCommandType = ms.getSqlCommandType();
        if (sqlCommandType != SqlCommandType.UPDATE) {
            return invocation.proceed();
        }
        Configuration configuration = ms.getConfiguration();
        String rawSql = this.showSql(configuration, ms.getBoundSql(args[1]));
        Statements sts = null;
        try {
            sts = CCJSqlParserUtil.parseStatements((String)rawSql);
        }
        catch (JSQLParserException e) {
            log.warn("SQL\u89e3\u6790\u5931\u8d25\uff0c\u8df3\u8fc7\u8be5SQL\uff1a\"" + rawSql.replaceAll("\n", "") + "\"\uff0c\u89e3\u6790\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return invocation.proceed();
        }
        ArrayList<Update> updateStats = new ArrayList<Update>();
        for (Statement st : sts.getStatements()) {
            if (!(st instanceof Update)) continue;
            updateStats.add((Update)st);
        }
        HashMap<SourceTable, UpdateNode> sourceUpdateMap = new HashMap<SourceTable, UpdateNode>();
        this.fillSourceMap(sourceUpdateMap, updateStats);
        Object result = invocation.proceed();
        if (!sourceUpdateMap.isEmpty()) {
            this.afterProceed(sourceUpdateMap);
        }
        return result;
    }

    private void fillSourceMap(Map<SourceTable, UpdateNode> sourceUpdateMap, List<Update> updateStats) {
        if (updateStats == null || updateStats.isEmpty()) {
            return;
        }
        for (Update update : updateStats) {
            if (!this.isSimpleUpdate(update)) continue;
            String tableName = update.getTable().getName();
            String tableAlias = null;
            if (update.getTable().getAlias() != null && StringUtils.isNotBlank((CharSequence)update.getTable().getAlias().getName())) {
                tableAlias = update.getTable().getAlias().getName();
            }
            if (!this.rule.constainsAssociation(tableName)) continue;
            for (Column col : update.getColumns()) {
                Set<SourceTable> sourceTables;
                if (!this.rule.constainsSourceRule(tableName, col.getColumnName()) || !this.rule.constainsAssociation(tableName, col.getColumnName()) || (sourceTables = this.rule.getSourceRule(tableName, col.getColumnName())).isEmpty()) continue;
                UpdateNode updateNode = new UpdateNode(tableName, tableAlias, update);
                List<Object> primaryList = this.uacMapper.listPrimary(tableName, tableAlias, sourceTables.iterator().next().getPrimaryColumn(), update.getWhere().toString());
                updateNode.setAffectedPrimaryList(primaryList);
                for (SourceTable sourceTable : sourceTables) {
                    sourceUpdateMap.put(sourceTable, updateNode);
                }
            }
        }
    }

    private void afterProceed(Map<SourceTable, UpdateNode> sourceUpdateMap) {
        if (sourceUpdateMap == null || sourceUpdateMap.isEmpty()) {
            return;
        }
        for (SourceTable sourceTable : sourceUpdateMap.keySet()) {
            UpdateNode updateNode = sourceUpdateMap.get(sourceTable);
            if (!this.rule.constainsTargetRule(sourceTable) || updateNode.getAffectedPrimaryList() == null || updateNode.getAffectedPrimaryList().isEmpty()) continue;
            HashSet<String> selectColumns = new HashSet<String>(2);
            selectColumns.add(sourceTable.getRootColumn());
            selectColumns.add(sourceTable.getSourceColumn());
            List<Map<String, Object>> selectResult = this.uacMapper.selectFromSource(updateNode.getTable(), new ArrayList<String>(selectColumns), sourceTable.getPrimaryColumn(), updateNode.getAffectedPrimaryList());
            this.updateTarget(sourceTable, selectResult);
        }
    }

    private void updateTarget(SourceTable sourceTable, List<Map<String, Object>> selectResult) {
        Set<TargetTable> targetTables = this.rule.getTargetRule(sourceTable);
        if (targetTables == null || selectResult == null) {
            return;
        }
        ArrayList<UpdateParam> updateParamList = new ArrayList<UpdateParam>();
        for (Map<String, Object> sourceData : selectResult) {
            Object value = sourceData.get(sourceTable.getSourceColumn());
            ConverterKey sKey = new ConverterKey(sourceTable.getTable(), sourceTable.getSourceColumn());
            if (this.sourceConverterMap.containsKey(sKey)) {
                List<AfterGetFromSourceConverter> converters = this.sourceConverterMap.get(sKey);
                for (AfterGetFromSourceConverter converter : converters) {
                    value = converter.convert(value, sourceTable);
                }
            }
            for (TargetTable targetTable : targetTables) {
                UpdateParam updateParam = new UpdateParam();
                updateParam.setTableName(targetTable.getTable());
                updateParam.setUpdateColumn(targetTable.getTargetColumn());
                updateParam.setWhereColumn(targetTable.getAssoColumn());
                updateParam.setWhereValue(sourceData.get(sourceTable.getRootColumn()));
                ConverterKey tKey = new ConverterKey(updateParam.getTableName(), updateParam.getUpdateColumn());
                if (this.targetConverterMap.containsKey(tKey)) {
                    List<BeforeUpdateTargetConverter> converters = this.targetConverterMap.get(tKey);
                    for (BeforeUpdateTargetConverter converter : converters) {
                        value = converter.convert(value, sourceTable, targetTable);
                    }
                }
                updateParam.setUpdateValue(value);
                updateParamList.add(updateParam);
            }
        }
        if (updateParamList.isEmpty()) {
            return;
        }
        try {
            if (this.allowMultiQueries) {
                this.uacMapper.batchUpdateToTarget(updateParamList);
            } else {
                for (UpdateParam updateParam : updateParamList) {
                    this.uacMapper.updateToTarget(updateParam);
                }
            }
        }
        catch (Exception e) {
            throw new SqlBoostException(e);
        }
    }

    private boolean isSimpleUpdate(Update update) {
        boolean isSimple = true;
        if (update.getStartJoins() != null && !update.getStartJoins().isEmpty()) {
            isSimple = false;
        }
        return isSimple;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private static class UpdateNode {
        String table;
        String alias;
        Update update;
        List<Object> affectedPrimaryList;

        public UpdateNode() {
        }

        public UpdateNode(String table, String alias, Update update) {
            this.table = table;
            this.alias = alias;
            this.update = update;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Update getUpdate() {
            return this.update;
        }

        public void setUpdate(Update update) {
            this.update = update;
        }

        public List<Object> getAffectedPrimaryList() {
            return this.affectedPrimaryList;
        }

        public void setAffectedPrimaryList(List<Object> affectedPrimaryList) {
            this.affectedPrimaryList = affectedPrimaryList;
        }

        public Expression getWhere() {
            return this.update.getWhere();
        }
    }

    private static class ConverterKey {
        String table;
        String column;

        public ConverterKey() {
        }

        public ConverterKey(String table, String column) {
            this.table = table;
            this.column = column;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConverterKey key = (ConverterKey)o;
            return Objects.equals(this.table, key.table) && Objects.equals(this.column, key.column);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.column);
        }
    }
}

