/*
 * Decompiled with CFR 0.152.
 */
import com.github.catalystcode.fortis.speechtotext.Transcriber;
import com.github.catalystcode.fortis.speechtotext.config.OutputFormat;
import com.github.catalystcode.fortis.speechtotext.config.SpeechServiceConfig;
import com.github.catalystcode.fortis.speechtotext.config.SpeechType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SpeechToTextWebsocketsDemo {
    public static void main(String[] stringArray) throws Exception {
        String string = System.getenv("OXFORD_SPEECH_TOKEN");
        SpeechType speechType = SpeechType.DICTATION;
        OutputFormat outputFormat = OutputFormat.SIMPLE;
        String string2 = stringArray[0];
        Locale locale = new Locale(stringArray.length > 1 ? stringArray[1] : "en-US");
        String string3 = stringArray.length > 2 ? stringArray[2] : string2;
        SpeechServiceConfig speechServiceConfig = new SpeechServiceConfig(string, speechType, outputFormat, locale);
        try (InputStream inputStream = SpeechToTextWebsocketsDemo.openStream(string2);){
            Transcriber.create(string3, speechServiceConfig).transcribe(inputStream, SpeechToTextWebsocketsDemo::onPhrase, SpeechToTextWebsocketsDemo::onHypothesis);
        }
    }

    private static InputStream openStream(String string) throws IOException {
        InputStream inputStream = string.startsWith("http://") || string.startsWith("https://") ? new URL(string).openConnection().getInputStream() : new FileInputStream(string);
        return new BufferedInputStream(inputStream);
    }

    private static void onPhrase(String string) {
        System.out.println("Phrase: " + string);
    }

    private static void onHypothesis(String string) {
        System.out.println("Hypothesis: " + string);
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
    }
}

