/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext;

import com.github.catalystcode.fortis.speechtotext.Transcriber;
import com.github.catalystcode.fortis.speechtotext.config.SpeechServiceConfig;
import com.github.catalystcode.fortis.speechtotext.utils.Environment;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import com.github.catalystcode.fortis.speechtotext.websocket.SpeechServiceClient;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javazoom.jl.converter.Converter;
import javazoom.jl.decoder.JavaLayerException;
import org.apache.log4j.Logger;

class Mp3Transcriber
extends Transcriber {
    private static final Logger log = Logger.getLogger(Mp3Transcriber.class);
    private final int bufferSize = Environment.getMp3BufferSize();

    Mp3Transcriber(SpeechServiceConfig speechServiceConfig, SpeechServiceClient speechServiceClient) {
        super(speechServiceConfig, speechServiceClient);
    }

    @Override
    protected void sendAudio(InputStream inputStream, MessageSender messageSender) throws IOException {
        int n;
        byte[] byArray = new byte[this.bufferSize];
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bufferSize);
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            if (n2 + n >= this.bufferSize) {
                log.info((Object)("Buffer full, starting to process " + n2 + " bytes"));
                String string = this.newTempFile(".mp3");
                Mp3Transcriber.writeBytes(string, byteBuffer, n2);
                this.sendAudioAsync(string, messageSender);
                byteBuffer.clear();
                byteBuffer.put(byArray, 0, n);
                n2 = n;
                continue;
            }
            byteBuffer.put(byArray, 0, n);
            log.debug((Object)("Buffered " + (n2 += n) + "/" + this.bufferSize + " bytes from MP3 stream"));
        }
        messageSender.sendAudioEnd();
    }

    private static void convertAudio(String string, String string2) throws JavaLayerException {
        log.debug((Object)("Starting to convert " + string + " to " + string2));
        new Converter().convert(string, string2);
        log.debug((Object)("Converted " + string + " to " + string2));
    }

    private static void writeBytes(String string, ByteBuffer byteBuffer, int n) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);
             FileChannel fileChannel = fileOutputStream.getChannel();){
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
        }
        log.debug((Object)("Wrote " + n + " bytes to " + string));
    }

    private void sendAudioAsync(String string, MessageSender messageSender) {
        new Thread(() -> {
            String string2;
            try {
                string2 = this.newTempFile(".wav");
            }
            catch (IOException iOException) {
                log.error((Object)"Error creating temp file", (Throwable)iOException);
                return;
            }
            try {
                Mp3Transcriber.convertAudio(string, string2);
            }
            catch (JavaLayerException javaLayerException) {
                log.error((Object)"Error converting MP3 to WAV", (Throwable)javaLayerException);
                return;
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));){
                messageSender.sendAudio(bufferedInputStream);
            }
            catch (Exception exception) {
                log.error((Object)"Error sending audio", (Throwable)exception);
            }
            finally {
                Mp3Transcriber.deleteTempFile(string);
                Mp3Transcriber.deleteTempFile(string2);
            }
        }).run();
    }

    private String newTempFile(String string) throws IOException {
        return Files.createTempFile(this.getClass().getName(), string, new FileAttribute[0]).toString();
    }

    private static void deleteTempFile(String string) {
        Path path = Paths.get(string, new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            log.error((Object)("Error deleting temp file: " + string), (Throwable)iOException);
        }
    }
}

