/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext;

import com.github.catalystcode.fortis.speechtotext.Mp3Transcriber;
import com.github.catalystcode.fortis.speechtotext.WavTranscriber;
import com.github.catalystcode.fortis.speechtotext.config.SpeechServiceConfig;
import com.github.catalystcode.fortis.speechtotext.lifecycle.MessageReceiver;
import com.github.catalystcode.fortis.speechtotext.utils.Func;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import com.github.catalystcode.fortis.speechtotext.websocket.SpeechServiceClient;
import com.github.catalystcode.fortis.speechtotext.websocket.nv.NvSpeechServiceClient;
import java.io.IOException;
import java.io.InputStream;

public abstract class Transcriber {
    protected final SpeechServiceConfig config;
    private final SpeechServiceClient client;

    Transcriber(SpeechServiceConfig speechServiceConfig, SpeechServiceClient speechServiceClient) {
        this.config = speechServiceConfig;
        this.client = speechServiceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcribe(InputStream inputStream, Func<String> func, Func<String> func2) throws Exception {
        MessageReceiver messageReceiver = new MessageReceiver(func, func2, this.client.getEndLatch());
        try {
            MessageSender messageSender = this.client.start(this.config, messageReceiver);
            messageReceiver.setSender(messageSender);
            messageSender.sendConfiguration();
            this.sendAudio(inputStream, messageSender);
            this.client.awaitEnd();
        }
        finally {
            this.client.stop();
        }
    }

    protected abstract void sendAudio(InputStream var1, MessageSender var2) throws IOException;

    public static Transcriber create(String string, SpeechServiceConfig speechServiceConfig) {
        return Transcriber.create(string, speechServiceConfig, new NvSpeechServiceClient());
    }

    private static Transcriber create(String string, SpeechServiceConfig speechServiceConfig, SpeechServiceClient speechServiceClient) {
        if (string.endsWith(".wav")) {
            return new WavTranscriber(speechServiceConfig, speechServiceClient);
        }
        if (string.endsWith(".mp3")) {
            return new Mp3Transcriber(speechServiceConfig, speechServiceClient);
        }
        throw new IllegalArgumentException("Unsupported audio file type: " + string);
    }
}

