/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.lifecycle;

import com.github.catalystcode.fortis.speechtotext.lifecycle.SpeechHypothesisMessage;
import com.github.catalystcode.fortis.speechtotext.lifecycle.SpeechPhraseMessage;
import com.github.catalystcode.fortis.speechtotext.lifecycle.TurnEndMessage;
import com.github.catalystcode.fortis.speechtotext.messages.MessageParser;
import com.github.catalystcode.fortis.speechtotext.telemetry.CallsTelemetry;
import com.github.catalystcode.fortis.speechtotext.utils.Func;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class MessageReceiver {
    private static final Logger log = Logger.getLogger(MessageReceiver.class);
    private final Func<String> onResult;
    private final Func<String> onHypothesis;
    private final CountDownLatch endLatch;
    private MessageSender sender;

    public MessageReceiver(Func<String> func, Func<String> func2, CountDownLatch countDownLatch) {
        this.onResult = func;
        this.onHypothesis = func2;
        this.endLatch = countDownLatch;
    }

    public void onMessage(String string) {
        Map<String, String> map = MessageParser.parseHeaders(string);
        JSONObject jSONObject = MessageParser.parseBody(string);
        String string2 = map.get("Path");
        String string3 = map.get("X-RequestId");
        CallsTelemetry.forId(string3).recordCall(string2);
        log.debug((Object)("Got message at path " + string2 + " with payload '" + jSONObject + "'"));
        if ("speech.hypothesis".equalsIgnoreCase(string2)) {
            SpeechHypothesisMessage.handle(jSONObject, this.onHypothesis);
        } else if ("speech.phrase".equalsIgnoreCase(string2)) {
            SpeechPhraseMessage.handle(jSONObject, this.onResult);
        } else if ("turn.end".equalsIgnoreCase(string2)) {
            TurnEndMessage.handle(this.sender, this.endLatch);
        }
    }

    public void setSender(MessageSender messageSender) {
        this.sender = messageSender;
    }
}

