/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.messages;

import com.github.catalystcode.fortis.speechtotext.messages.HeaderCreator;
import com.github.catalystcode.fortis.speechtotext.utils.RiffHeader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class BinaryMessageCreator {
    private boolean isFirstMessage;

    public BinaryMessageCreator() {
        this(true);
    }

    BinaryMessageCreator(boolean bl) {
        this.isFirstMessage = bl;
    }

    public ByteBuffer createBinaryMessage(String string, String string2, String string3, byte[] byArray, int n) {
        byte[] byArray2 = BinaryMessageCreator.formatHeaders(string, string2, string3);
        ByteBuffer byteBuffer = this.allocateBuffer(n, byArray2.length);
        BinaryMessageCreator.putHeader(byArray2, byteBuffer);
        this.putContent(byArray, n, byteBuffer);
        this.updateState();
        return byteBuffer;
    }

    private static byte[] formatHeaders(String string, String string2, String string3) {
        return HeaderCreator.addHeaders(new StringBuilder(), string, string2, string3).toString().getBytes(StandardCharsets.UTF_8);
    }

    private void putContent(byte[] byArray, int n, ByteBuffer byteBuffer) {
        int n2;
        if (n <= 0) {
            return;
        }
        int n3 = this.isFirstMessage ? 44 : 0;
        int n4 = n2 = this.isFirstMessage ? n - 44 : n;
        if (this.isFirstMessage) {
            RiffHeader.putRiffHeader(byteBuffer, 16000, (short)1);
        }
        byteBuffer.put(byArray, n3, n2);
    }

    private void updateState() {
        if (this.isFirstMessage) {
            this.isFirstMessage = false;
        }
    }

    private static void putHeader(byte[] byArray, ByteBuffer byteBuffer) {
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
    }

    private ByteBuffer allocateBuffer(int n, int n2) {
        int n3 = 2 + n2;
        if (this.isFirstMessage) {
            n3 += 44;
        }
        return ByteBuffer.allocate(n3 += n);
    }
}

